/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.net;

import de.dailab.jiac.net.discovery.SourceAwareDiscoveryEvent;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.Service;
import org.apache.activemq.broker.SslContext;
import org.apache.activemq.command.DiscoveryEvent;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.DemandForwardingBridgeSupport;
import org.apache.activemq.network.NetworkBridge;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.network.NetworkBridgeFactory;
import org.apache.activemq.network.NetworkBridgeListener;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.transport.discovery.DiscoveryAgentFactory;
import org.apache.activemq.transport.discovery.DiscoveryListener;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.apache.activemq.util.URISupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SourceAwareDiscoveryNetworkConnector
extends NetworkConnector
implements DiscoveryListener {
    private static final Log LOG = LogFactory.getLog(SourceAwareDiscoveryNetworkConnector.class);
    private DiscoveryAgent discoveryAgent;
    private ConcurrentHashMap<URI, NetworkBridge> bridges = new ConcurrentHashMap();
    private Map<String, String> parameters;
    private boolean _useAlwaysSourceAddress = false;

    public SourceAwareDiscoveryNetworkConnector() {
    }

    public SourceAwareDiscoveryNetworkConnector(URI discoveryURI) throws IOException {
        this.setUri(discoveryURI);
    }

    public void setUri(URI discoveryURI) throws IOException {
        this.setDiscoveryAgent(DiscoveryAgentFactory.createDiscoveryAgent((URI)discoveryURI));
        try {
            this.parameters = URISupport.parseParamters((URI)discoveryURI);
            IntrospectionSupport.setProperties((Object)this.getDiscoveryAgent(), this.parameters);
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)("failed to parse query parameters from discoveryURI: " + discoveryURI), (Throwable)e);
        }
    }

    public void useAlwaysSourceAddress(boolean value) {
        this._useAlwaysSourceAddress = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceAdd(DiscoveryEvent event) {
        String localURIName = this.localURI.getScheme() + "://" + this.localURI.getHost();
        if (this.serviceSupport.isStopped() || this.serviceSupport.isStopping()) {
            return;
        }
        String url = event.getServiceName();
        if (url != null) {
            Transport localTransport;
            Transport remoteTransport;
            InetAddress source;
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                LOG.warn((Object)("Could not connect to remote URI: " + url + " due to bad URI syntax: " + e), (Throwable)e);
                return;
            }
            if (this.bridges.containsKey(uri)) {
                LOG.debug((Object)("Discovery agent generated a duplicate onServiceAdd event for: " + uri));
                return;
            }
            if (this.localURI.equals(uri) || this.connectionFilter != null && !this.connectionFilter.connectTo(uri)) {
                LOG.debug((Object)("not connecting loopback: " + uri));
                return;
            }
            URI connectUri = uri;
            InetAddress inetAddress = source = event instanceof SourceAwareDiscoveryEvent ? ((SourceAwareDiscoveryEvent)event).getSource() : null;
            if (source != null) {
                boolean useSource = this._useAlwaysSourceAddress;
                if (!useSource) {
                    try {
                        InetAddress[] addresses = InetAddress.getAllByName(connectUri.getHost());
                        useSource = addresses == null || addresses.length <= 0;
                    }
                    catch (UnknownHostException uhe) {
                        useSource = true;
                    }
                }
                if (useSource) {
                    LOG.info((Object)("Could not resolve remote host: " + connectUri));
                    try {
                        connectUri = new URI(uri.getScheme(), uri.getUserInfo(), source.getHostAddress(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
                    }
                    catch (URISyntaxException e) {
                        LOG.warn((Object)("Could not create remote URI from source: " + e.getMessage()));
                        return;
                    }
                }
            }
            try {
                connectUri = URISupport.applyParameters((URI)connectUri, this.parameters);
            }
            catch (URISyntaxException e) {
                LOG.warn((Object)("could not apply query parameters: " + this.parameters + " to: " + connectUri), (Throwable)e);
            }
            LOG.info((Object)("Establishing network connection from " + localURIName + " to " + connectUri));
            try {
                SslContext.setCurrentSslContext((SslContext)this.getBrokerService().getSslContext());
                try {
                    remoteTransport = TransportFactory.connect((URI)connectUri);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Could not connect to remote URI: " + connectUri + ": " + e.getMessage()));
                    LOG.debug((Object)("Connection failure exception: " + e), (Throwable)e);
                    SslContext.setCurrentSslContext(null);
                    return;
                }
                try {
                    localTransport = this.createLocalTransport();
                }
                catch (Exception e) {
                    ServiceSupport.dispose((Service)remoteTransport);
                    LOG.warn((Object)("Could not connect to local URI: " + localURIName + ": " + e.getMessage()));
                    LOG.debug((Object)("Connection failure exception: " + e), (Throwable)e);
                    SslContext.setCurrentSslContext(null);
                    return;
                }
            }
            finally {
                SslContext.setCurrentSslContext(null);
            }
            NetworkBridge bridge = this.createBridge(localTransport, remoteTransport, event);
            try {
                bridge.start();
                this.bridges.put(uri, bridge);
            }
            catch (Exception e) {
                ServiceSupport.dispose((Service)localTransport);
                ServiceSupport.dispose((Service)remoteTransport);
                LOG.warn((Object)("Could not start network bridge between: " + localURIName + " and: " + uri + " due to: " + e));
                LOG.debug((Object)("Start failure exception: " + e), (Throwable)e);
                try {
                    this.discoveryAgent.serviceFailed(event);
                }
                catch (IOException e1) {
                    LOG.debug((Object)("Discovery agent failure while handling failure event: " + e1.getMessage()), (Throwable)e1);
                }
                return;
            }
        }
    }

    public void onServiceRemove(DiscoveryEvent event) {
        String url = event.getServiceName();
        if (url != null) {
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                LOG.warn((Object)("Could not connect to remote URI: " + url + " due to bad URI syntax: " + e), (Throwable)e);
                return;
            }
            NetworkBridge bridge = this.bridges.remove(uri);
            if (bridge == null) {
                return;
            }
            ServiceSupport.dispose((Service)bridge);
        }
    }

    public DiscoveryAgent getDiscoveryAgent() {
        return this.discoveryAgent;
    }

    public void setDiscoveryAgent(DiscoveryAgent discoveryAgent) {
        this.discoveryAgent = discoveryAgent;
        if (discoveryAgent != null) {
            this.discoveryAgent.setDiscoveryListener((DiscoveryListener)this);
        }
    }

    protected void handleStart() throws Exception {
        if (this.discoveryAgent == null) {
            throw new IllegalStateException("You must configure the 'discoveryAgent' property");
        }
        this.discoveryAgent.start();
        super.handleStart();
    }

    protected void handleStop(ServiceStopper stopper) throws Exception {
        for (NetworkBridge bridge : this.bridges.values()) {
            try {
                bridge.stop();
            }
            catch (Exception e) {
                stopper.onException((Object)this, (Throwable)e);
            }
        }
        try {
            this.discoveryAgent.stop();
        }
        catch (Exception e) {
            stopper.onException((Object)this, (Throwable)e);
        }
        super.handleStop(stopper);
    }

    protected NetworkBridge createBridge(Transport localTransport, Transport remoteTransport, final DiscoveryEvent event) {
        NetworkBridgeListener listener = new NetworkBridgeListener(){

            public void bridgeFailed() {
                if (!SourceAwareDiscoveryNetworkConnector.this.serviceSupport.isStopped()) {
                    try {
                        SourceAwareDiscoveryNetworkConnector.this.discoveryAgent.serviceFailed(event);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            public void onStart(NetworkBridge bridge) {
                SourceAwareDiscoveryNetworkConnector.this.registerNetworkBridgeMBean(bridge);
            }

            public void onStop(NetworkBridge bridge) {
                SourceAwareDiscoveryNetworkConnector.this.unregisterNetworkBridgeMBean(bridge);
            }
        };
        DemandForwardingBridge result = NetworkBridgeFactory.createBridge((NetworkBridgeConfiguration)this, (Transport)localTransport, (Transport)remoteTransport, (NetworkBridgeListener)listener);
        result.setBrokerService(this.getBrokerService());
        return this.configureBridge((DemandForwardingBridgeSupport)result);
    }

    public String getName() {
        String name = super.getName();
        if (name == null) {
            name = this.discoveryAgent.toString();
            super.setName(name);
        }
        return name;
    }

    public String toString() {
        return "DiscoveryNetworkConnector:" + this.getName() + ":" + this.getBrokerService();
    }
}

