/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.inference;

import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.owl.inference.OWLIndividualReasoner;
import org.semanticweb.owl.inference.OWLTaxonomyReasoner;
import org.semanticweb.owl.io.vocabulary.OWLVocabularyAdapter;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.change.AddEntity;
import org.semanticweb.owl.model.change.AddSuperClass;
import org.semanticweb.owl.model.change.ChangeVisitor;
import org.semanticweb.owl.model.helper.OntologyHelper;

public class InferenceHelper {
    static Logger logger = Logger.getLogger((Class)(class$uk$ac$man$cs$img$owl$inference$InferenceHelper == null ? (class$uk$ac$man$cs$img$owl$inference$InferenceHelper = InferenceHelper.class$("uk.ac.man.cs.img.owl.inference.InferenceHelper")) : class$uk$ac$man$cs$img$owl$inference$InferenceHelper));
    static /* synthetic */ Class class$uk$ac$man$cs$img$owl$inference$InferenceHelper;

    private static void dumpHierarchy(OWLTaxonomyReasoner reasoner, PrintWriter pw, OWLClass clazz, int level) throws OWLException {
        for (int i = 0; i < level; ++i) {
            pw.print(" ");
        }
        pw.println(clazz.getURI());
        Set subs = reasoner.subClassesOf(clazz);
        Iterator sit = subs.iterator();
        while (sit.hasNext()) {
            Iterator innerIt = ((Set)sit.next()).iterator();
            while (innerIt.hasNext()) {
                OWLClass cl = (OWLClass)innerIt.next();
                InferenceHelper.dumpHierarchy(reasoner, pw, cl, level + 1);
            }
        }
    }

    public static void dumpHierarchy(OWLTaxonomyReasoner reasoner, PrintWriter pw) throws OWLException {
        try {
            OWLClass thing = reasoner.getOntology().getClass(new URI(OWLVocabularyAdapter.INSTANCE.getThing()));
            InferenceHelper.dumpHierarchy(reasoner, pw, thing, 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void dumpInstances(OWLIndividualReasoner reasoner, PrintWriter pw) throws OWLException {
        Set allOntologies = OntologyHelper.importClosure((OWLOntology)reasoner.getOntology());
        HashSet allClasses = new HashSet();
        Iterator allIt = allOntologies.iterator();
        while (allIt.hasNext()) {
            OWLOntology ontologyToProcess = (OWLOntology)allIt.next();
            logger.debug((Object)("Ontology: " + ontologyToProcess.getURI()));
            allClasses.addAll(ontologyToProcess.getClasses());
        }
        Iterator it = allClasses.iterator();
        while (it.hasNext()) {
            OWLClass clazz = (OWLClass)it.next();
            Set individuals = reasoner.instancesOf((OWLDescription)clazz);
            pw.println(clazz.getURI());
            Iterator indIt = individuals.iterator();
            while (indIt.hasNext()) {
                OWLIndividual ind = (OWLIndividual)indIt.next();
                pw.println("... " + ind.getURI());
            }
        }
    }

    public static void dumpHierarchyRDFS(OWLTaxonomyReasoner reasoner, PrintWriter pw) throws OWLException {
        try {
            pw.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            pw.println("<rdf:RDF xmlns:dc=\"http://purl.org/dc/elements/1.1/\"");
            pw.println("    xmlns:owl=\"http://www.w3.org/2002/07/owl#\"");
            pw.println("    xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"");
            pw.println("    xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\"");
            pw.println("    xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\">");
            Iterator it = reasoner.getOntology().getClasses().iterator();
            while (it.hasNext()) {
                OWLClass clazz = (OWLClass)it.next();
                Set subs = reasoner.subClassesOf(clazz);
                Iterator sit = subs.iterator();
                while (sit.hasNext()) {
                    Iterator innerIt = ((Set)sit.next()).iterator();
                    while (innerIt.hasNext()) {
                        OWLClass cl = (OWLClass)innerIt.next();
                        pw.println("<owl:Class rdf:about=\"" + cl.getURI() + "\">");
                        pw.println("  <rdfs:subClassOf>");
                        pw.println("    <owl:Class rdf:about=\"" + clazz.getURI() + "\"/>");
                        pw.println("  </rdfs:subClassOf>");
                        pw.println("</owl:Class>");
                    }
                }
            }
            pw.println("</rdf:RDF>");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static OWLOntology hierarchyAsNewOntology(OWLTaxonomyReasoner reasoner) throws OWLException {
        OWLClass clazz;
        OWLOntology ontology = reasoner.getOntology();
        URI uri = null;
        try {
            uri = new URI(ontology.getURI().toString() + "-hierarchy");
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
        OWLOntology newOntology = ontology.getOWLDataFactory().getOWLOntology(uri, uri);
        ChangeVisitor visitor = (ChangeVisitor)newOntology;
        OWLOntology theOntology = reasoner.getOntology();
        Set allOntologies = OntologyHelper.importClosure((OWLOntology)theOntology);
        HashSet allClasses = new HashSet();
        Iterator allIt = allOntologies.iterator();
        while (allIt.hasNext()) {
            OWLOntology ontologyToProcess = (OWLOntology)allIt.next();
            logger.debug((Object)("Ontology: " + ontologyToProcess.getURI()));
            allClasses.addAll(ontologyToProcess.getClasses());
        }
        Iterator it = allClasses.iterator();
        while (it.hasNext()) {
            clazz = (OWLClass)it.next();
            logger.debug((Object)("Adding Class: " + clazz.getURI()));
            AddEntity oc = new AddEntity(newOntology, (OWLEntity)clazz, null);
            oc.accept(visitor);
        }
        it = allClasses.iterator();
        while (it.hasNext()) {
            AddEntity oc;
            OWLClass cl;
            Iterator innerIt;
            clazz = (OWLClass)it.next();
            logger.debug((Object)("Class: " + clazz.getURI()));
            Set sups = reasoner.superClassesOf(clazz);
            logger.debug((Object)("Sups: " + sups.size()));
            Iterator sit = sups.iterator();
            while (sit.hasNext()) {
                Set ss = (Set)sit.next();
                innerIt = ss.iterator();
                while (innerIt.hasNext()) {
                    cl = (OWLClass)innerIt.next();
                    logger.debug((Object)("Adding super: " + cl.getURI()));
                    oc = new AddSuperClass(newOntology, clazz, (OWLDescription)cl, null);
                    oc.accept(visitor);
                }
            }
            Set equivs = reasoner.equivalentClassesOf(clazz);
            Iterator sit2 = equivs.iterator();
            while (sit2.hasNext()) {
                innerIt = ((Set)sit2.next()).iterator();
                while (innerIt.hasNext()) {
                    cl = (OWLClass)innerIt.next();
                    if (cl == clazz) continue;
                    oc = new AddEntity(newOntology, (OWLEntity)cl, null);
                    oc.accept(visitor);
                    oc = new AddSuperClass(newOntology, clazz, (OWLDescription)cl, null);
                    oc.accept(visitor);
                    oc = new AddSuperClass(newOntology, cl, (OWLDescription)clazz, null);
                    oc.accept(visitor);
                }
            }
        }
        return newOntology;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

