/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.inference.dl;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.inference.OWLClassReasoner;
import org.semanticweb.owl.inference.OWLIndividualReasoner;
import org.semanticweb.owl.io.vocabulary.OWLVocabularyAdapter;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.change.OntologyChange;
import org.semanticweb.owl.model.change.OntologyChangeListener;
import org.semanticweb.owl.model.change.OntologyChangeSource;
import org.semanticweb.owl.model.helper.OntologyHelper;
import org.semanticweb.owl.validation.SpeciesValidator;
import org.semanticweb.owl.validation.SpeciesValidatorReporter;
import org.w3c.dom.Element;
import uk.ac.man.cs.img.dig.helper.Response;
import uk.ac.man.cs.img.dig.reasoner.Reasoner;
import uk.ac.man.cs.img.dig.reasoner.impl.HTTPReasoner;
import uk.ac.man.cs.img.owl.inference.dl.ReasonerProxy;
import uk.ac.man.cs.img.owl.io.dig1_0.Renderer;
import uk.ac.man.cs.img.owl.io.dig1_0.RenderingVisitor;

public class SimpleOWLReasoner
implements OWLClassReasoner,
OWLIndividualReasoner,
OntologyChangeListener,
ReasonerProxy {
    private OWLOntology ontology;
    private Reasoner digReasoner;
    private RenderingVisitor renderer;
    private SpeciesValidator validator;
    private static int OK = 0;
    private static int NOTOK = 1;
    private static int UNKNOWN = 2;
    private int status;

    public SimpleOWLReasoner(Reasoner digReasoner) throws OWLException {
        this.digReasoner = digReasoner;
        this.renderer = new RenderingVisitor();
        this.validator = new uk.ac.man.cs.img.owl.validation.SpeciesValidator();
        this.validator.setReporter(new SpeciesValidatorReporter(){

            public void ontology(OWLOntology onto) {
            }

            public void done(String str) {
            }

            public void message(String str) {
            }

            public void explain(int l, String str) {
            }

            public void explain(int l, int code, String str) {
            }
        });
        this.status = UNKNOWN;
    }

    public void setOntology(OWLOntology onto) throws OWLException {
        if (this.ontology != null && this.ontology instanceof OntologyChangeSource) {
            ((OntologyChangeSource)this.ontology).removeOntologyChangeListener((OntologyChangeListener)this);
            this.ontology = null;
        }
        if (onto != null) {
            this.ontology = onto;
            if (this.ontology instanceof OntologyChangeSource) {
                ((OntologyChangeSource)this.ontology).addOntologyChangeListener((OntologyChangeListener)this);
            }
            this.status = UNKNOWN;
            this.checkStatus();
        }
    }

    private void initialiseReasoner() throws OWLException {
        this.tell("<clearKB/>");
        this.tell("<defconcept name=\"" + OWLVocabularyAdapter.INSTANCE.getThing() + "\"/>");
        this.tell("<equalc><catom name=\"" + OWLVocabularyAdapter.INSTANCE.getThing() + "\"/><top/></equalc>");
        this.tell("<defconcept name=\"" + OWLVocabularyAdapter.INSTANCE.getNothing() + "\"/>");
        this.tell("<equalc><catom name=\"" + OWLVocabularyAdapter.INSTANCE.getNothing() + "\"/><bottom/></equalc>");
    }

    public void tell(String str) throws OWLException {
        StringWriter sw = new StringWriter();
        sw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sw.write("<tells xmlns=\"http://dl.kr.org/dig/lang\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://dl.kr.org/dig/lang dig.xsd\">");
        sw.write(str);
        sw.write("</tells>");
        StringWriter response = new StringWriter();
        try {
            this.digReasoner.request((Reader)new StringReader(sw.toString()), (Writer)response);
        }
        catch (Exception e) {
            throw new OWLException(e.getMessage());
        }
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    private void transmitOntology() throws OWLException {
        this.initialiseReasoner();
        try {
            Renderer renderer = new Renderer();
            StringWriter sw = new StringWriter();
            renderer.renderOntology(this.ontology, (Writer)sw);
            StringWriter response = new StringWriter();
            this.digReasoner.request((Reader)new StringReader(sw.toString()), (Writer)response);
        }
        catch (Exception e) {
            throw new OWLException(e.getMessage());
        }
    }

    public boolean isSubClassOf(OWLDescription d1, OWLDescription d2) throws OWLException {
        this.checkStatus();
        StringWriter sw = new StringWriter();
        sw.write("<asks xmlns=\"http://dl.kr.org/dig/lang\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://dl.kr.org/dig/lang dig.xsd\">");
        sw.write("<subsumes id=\"q\">");
        this.renderer.reset();
        d2.accept((OWLObjectVisitor)this.renderer);
        sw.write(this.renderer.result());
        this.renderer.reset();
        d1.accept((OWLObjectVisitor)this.renderer);
        sw.write(this.renderer.result());
        sw.write("</subsumes>");
        sw.write("</asks>");
        StringWriter response = new StringWriter();
        try {
            this.digReasoner.request((Reader)new StringReader(sw.toString()), (Writer)response);
        }
        catch (Exception e) {
            throw new OWLException(e.getMessage());
        }
        Response serverResponse = new Response(response.toString());
        Element r = serverResponse.extractResponse("q");
        return r.getTagName().equals("true");
    }

    public boolean isEquivalentClass(OWLDescription d1, OWLDescription d2) throws OWLException {
        return this.isSubClassOf(d1, d2) & this.isSubClassOf(d2, d1);
    }

    public boolean isConsistent(OWLDescription d1) throws OWLException {
        this.checkStatus();
        StringWriter sw = new StringWriter();
        sw.write("<asks xmlns=\"http://dl.kr.org/dig/lang\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://dl.kr.org/dig/lang dig.xsd\">");
        sw.write("<satisfiable id=\"q\">");
        this.renderer.reset();
        d1.accept((OWLObjectVisitor)this.renderer);
        sw.write(this.renderer.result());
        sw.write("</satisfiable>");
        sw.write("</asks>");
        StringWriter response = new StringWriter();
        try {
            this.digReasoner.request((Reader)new StringReader(sw.toString()), (Writer)response);
        }
        catch (Exception e) {
            throw new OWLException(e.getMessage());
        }
        Response serverResponse = new Response(response.toString());
        Element r = serverResponse.extractResponse("q");
        return r.getTagName().equals("true");
    }

    public boolean isConsistent() throws OWLException {
        this.notImplemented("isConsistent");
        return false;
    }

    public Set superClassesOf(OWLDescription d) throws OWLException {
        this.checkStatus();
        return this.getHierarchy("parents", d);
    }

    public Set subClassesOf(OWLDescription d) throws OWLException {
        this.checkStatus();
        return this.getHierarchy("children", d);
    }

    public Set ancestorClassesOf(OWLDescription d) throws OWLException {
        this.checkStatus();
        return this.getHierarchy("ancestors", d);
    }

    public Set descendantClassesOf(OWLDescription d) throws OWLException {
        this.checkStatus();
        return this.getHierarchy("descendants", d);
    }

    public Set equivalentClassesOf(OWLDescription d) throws OWLException {
        this.checkStatus();
        return this.getHierarchy("equivalents", d);
    }

    private Set getHierarchy(String queryTag, OWLDescription d) throws OWLException {
        StringWriter sw = new StringWriter();
        HashSet result = new HashSet();
        sw.write("<asks xmlns=\"http://dl.kr.org/dig/lang\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://dl.kr.org/dig/lang dig.xsd\">");
        sw.write("<" + queryTag + " id=\"q\">");
        this.renderer.reset();
        d.accept((OWLObjectVisitor)this.renderer);
        sw.write(this.renderer.result());
        sw.write("</" + queryTag + ">");
        sw.write("</asks>");
        StringWriter response = new StringWriter();
        try {
            this.digReasoner.request((Reader)new StringReader(sw.toString()), (Writer)response);
        }
        catch (Exception e) {
            throw new OWLException(e.getMessage());
        }
        Response serverResponse = new Response(response.toString());
        Element r = serverResponse.extractResponse("q");
        List syns = serverResponse.extractSynonymSets(r);
        Iterator it = syns.iterator();
        while (it.hasNext()) {
            HashSet<OWLClass> innerSet = new HashSet<OWLClass>();
            List names = (List)it.next();
            Iterator nameIt = names.iterator();
            while (nameIt.hasNext()) {
                Response.Concept c = (Response.Concept)nameIt.next();
                OWLClass clazz = this.conceptToClass(c);
                if (clazz == null) continue;
                innerSet.add(clazz);
            }
            result.add(innerSet);
        }
        return result;
    }

    private OWLClass conceptToClass(Response.Concept c) throws OWLException {
        try {
            if (c.isBottom()) {
                OWLClass clazz = this.ontology.getClass(new URI(OWLVocabularyAdapter.INSTANCE.getNothing()));
                return clazz;
            }
            if (c.isTop()) {
                return this.ontology.getClass(new URI(OWLVocabularyAdapter.INSTANCE.getThing()));
            }
            Response.ConceptName cn = (Response.ConceptName)c;
            URI classURI = new URI(cn.toString());
            OWLClass clazz = this.ontology.getOWLDataFactory().getOWLClass(classURI);
            return clazz;
        }
        catch (URISyntaxException ex) {
            throw new OWLException(ex.getMessage());
        }
    }

    public void ontologyChanged(OntologyChange event) throws OWLException {
        this.status = UNKNOWN;
    }

    private void checkStatus() throws OWLException {
        if (this.status == UNKNOWN) {
            if (!this.validator.isOWLDL(this.ontology)) {
                this.status = NOTOK;
            } else {
                this.status = OK;
                this.transmitOntology();
            }
        }
        if (this.status == NOTOK) {
            throw new ExpressivenessOutOfScopeException("Ontology: " + this.ontology.getURI() + " is not OWL DL!\nThis reasoner can only reason about DL ontologies.");
        }
    }

    public boolean isInstanceOf(OWLIndividual i, OWLDescription d) throws OWLException {
        this.notImplemented("isInstanceOf");
        return false;
    }

    public Set instancesOf(OWLDescription d1) throws OWLException {
        HashSet<OWLIndividual> result = new HashSet<OWLIndividual>();
        try {
            this.checkStatus();
            StringWriter sw = new StringWriter();
            sw.write("<asks xmlns=\"http://dl.kr.org/dig/lang\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://dl.kr.org/dig/lang dig.xsd\">");
            sw.write("<instances id=\"q\">");
            this.renderer.reset();
            d1.accept((OWLObjectVisitor)this.renderer);
            sw.write(this.renderer.result());
            sw.write("</instances>");
            sw.write("</asks>");
            StringWriter response = new StringWriter();
            try {
                this.digReasoner.request((Reader)new StringReader(sw.toString()), (Writer)response);
            }
            catch (Exception e) {
                throw new OWLException(e.getMessage());
            }
            Response serverResponse = new Response(response.toString());
            Element r = serverResponse.extractResponse("q");
            List l = serverResponse.extractIndividuals(r);
            HashSet<String> seen = new HashSet<String>();
            for (int j = 0; j < l.size(); ++j) {
                String name = (String)l.get(j);
                if (seen.contains(name)) continue;
                OWLIndividual i = this.ontology.getOWLDataFactory().getOWLIndividual(new URI(name));
                result.add(i);
                seen.add(name);
            }
        }
        catch (ExpressivenessOutOfScopeException ex) {
            throw new OWLException(ex.getMessage());
        }
        catch (Exception ex) {
            throw new OWLException(ex.getMessage());
        }
        return result;
    }

    private void notImplemented(String message) throws OWLException {
        throw new OWLException(message + ": Not yet implemented");
    }

    public static void main(String[] args) {
        try {
            BasicConfigurator.configure();
            URI uri = new URI(args[1]);
            HTTPReasoner digReasoner = new HTTPReasoner(args[0]);
            SimpleOWLReasoner reasoner = new SimpleOWLReasoner((Reasoner)digReasoner);
            OWLOntology onto = OntologyHelper.getOntology((URI)uri);
            reasoner.setOntology(onto);
            try {
                if (!reasoner.isConsistent()) {
                    System.out.println("!!! Inconsistent Ontology !!!");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Iterator it = onto.getClasses().iterator();
            while (it.hasNext()) {
                OWLClass clazz = (OWLClass)it.next();
                if (!reasoner.isConsistent((OWLDescription)clazz)) {
                    System.out.println("Unsatisfiable Class: " + clazz.getURI());
                }
                System.out.println(clazz.getURI());
                Set subs = reasoner.subClassesOf((OWLDescription)clazz);
                Iterator sit = subs.iterator();
                while (sit.hasNext()) {
                    Iterator innerIt = ((Set)sit.next()).iterator();
                    while (innerIt.hasNext()) {
                        OWLClass cl = (OWLClass)innerIt.next();
                        System.out.println("> " + cl.getURI());
                        System.out.println(reasoner.isSubClassOf((OWLDescription)cl, (OWLDescription)clazz));
                    }
                }
                Set supers = reasoner.superClassesOf((OWLDescription)clazz);
                Iterator sit2 = supers.iterator();
                while (sit2.hasNext()) {
                    Iterator innerIt = ((Set)sit2.next()).iterator();
                    while (innerIt.hasNext()) {
                        OWLClass cl = (OWLClass)innerIt.next();
                        System.out.println("< " + cl.getURI());
                        System.out.println(reasoner.isSubClassOf((OWLDescription)clazz, (OWLDescription)cl));
                    }
                }
                Set equivs = reasoner.equivalentClassesOf((OWLDescription)clazz);
                Iterator eit = equivs.iterator();
                while (eit.hasNext()) {
                    Iterator innerIt = ((Set)eit.next()).iterator();
                    while (innerIt.hasNext()) {
                        OWLClass cl = (OWLClass)innerIt.next();
                        System.out.println("= " + cl.getURI());
                        System.out.println(reasoner.isEquivalentClass((OWLDescription)clazz, (OWLDescription)cl));
                    }
                }
            }
        }
        catch (ExpressivenessOutOfScopeException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public class ExpressivenessOutOfScopeException
    extends OWLException {
        ExpressivenessOutOfScopeException(String m) {
            super(m);
        }
    }
}

