/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.inference.firstorder;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.io.owl_rdf.OWLRDFErrorHandler;
import org.semanticweb.owl.io.owl_rdf.OWLRDFParser;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.util.OWLManager;
import org.xml.sax.SAXException;
import uk.ac.man.cs.img.owl.io.tptp.Renderer;
import uk.ac.man.cs.img.owl.test.OWLTest;
import uk.ac.man.cs.img.owl.test.OWLTestParser;
import uk.ac.man.cs.img.owl.test.OWLTestVocabularyAdapter;

public class TPTPConverter {
    static final String owlTestURL = "http://www.w3.org/2002/03owlt/";

    public static void main(String[] args) {
        BasicConfigurator.configure();
        try {
            TPTPConverter.convert(args[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void convert(String uriString) throws Exception {
        URI url = new URI(uriString);
        OWLTestParser otp = new OWLTestParser();
        OWLTest test = otp.parseTest(url);
        String testURI = test.getURI().toString();
        HashSet levels = (HashSet)test.getDocumentLevels().get(testURI);
        if (testURI.startsWith(owlTestURL)) {
            testURI = testURI.substring(owlTestURL.length());
        }
        if (testURI.endsWith("#test")) {
            testURI = testURI.substring(0, testURI.length() - 5);
        }
        testURI = testURI.replace('/', '-');
        String fname = testURI + ".tptp";
        FileWriter fw = new FileWriter(fname);
        if (levels == null) {
            levels = new HashSet();
        }
        PrintWriter headerWriter = new PrintWriter(fw);
        headerWriter.println("% --------------------------------------------------------------------------");
        headerWriter.println("% TPTP Translation of OWL Test");
        headerWriter.println("% ");
        headerWriter.println("% Test URL: " + test.getURI());
        headerWriter.println("% ");
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        headerWriter.println("% Translated: " + sdf.format(new Date()));
        headerWriter.println("% ");
        String description = (String)test.getDescriptions().get(test.getURI());
        if (description != null) {
            headerWriter.println("% Test Description:");
            headerWriter.print("% ");
            for (int i = 0; i < description.length(); ++i) {
                char c = description.charAt(i);
                if (c != '\n') {
                    headerWriter.print(c);
                    continue;
                }
                headerWriter.println();
                headerWriter.print("% ");
            }
        }
        headerWriter.println();
        if (levels.contains(OWLTestVocabularyAdapter.INSTANCE.getOWLLite())) {
            headerWriter.println("% Test-level: OWL-Lite ");
        } else if (levels.contains(OWLTestVocabularyAdapter.INSTANCE.getOWLDL())) {
            headerWriter.println("% Test-level: OWL-DL ");
        } else if (((Object)levels).equals(OWLTestVocabularyAdapter.INSTANCE.getOWLFull())) {
            headerWriter.println("% Test-level: OWL-Full ");
        }
        headerWriter.println("% ");
        headerWriter.println("% --------------------------------------------------------------------------");
        try {
            if (test.getType().equals(OWLTestVocabularyAdapter.INSTANCE.getInconsistencyTest()) || test.getType().equals(OWLTestVocabularyAdapter.INSTANCE.getConsistencyTest())) {
                Iterator it = test.getDocuments().iterator();
                while (it.hasNext()) {
                    String doc = (String)it.next();
                    if (!test.getDocumentRoles().get(doc).equals(OWLTestVocabularyAdapter.INSTANCE.getInputDocument())) continue;
                    OWLOntology ontology = TPTPConverter.getOntology(doc);
                    Renderer renderer = new Renderer();
                    renderer.setNegate(false);
                    renderer.renderOntology(ontology, (Writer)fw);
                }
                fw.close();
            } else if (test.getType().equals(OWLTestVocabularyAdapter.INSTANCE.getPositiveEntailmentTest()) || test.getType().equals(OWLTestVocabularyAdapter.INSTANCE.getNegativeEntailmentTest())) {
                ArrayList names = new ArrayList();
                ArrayList strings = new ArrayList();
                ArrayList integers = new ArrayList();
                ArrayList others = new ArrayList();
                ArrayList types = new ArrayList();
                Iterator it = test.getDocuments().iterator();
                while (it.hasNext()) {
                    Renderer renderer;
                    OWLOntology ontology;
                    String doc = (String)it.next();
                    if (test.getDocumentRoles().get(doc).equals(OWLTestVocabularyAdapter.INSTANCE.getPremiseDocument())) {
                        ontology = TPTPConverter.getOntology(doc);
                        renderer = new Renderer();
                        renderer.setNegate(false);
                        renderer.renderOntology(ontology, (Writer)fw, names, strings, integers, others, types);
                    }
                    if (!test.getDocumentRoles().get(doc).equals(OWLTestVocabularyAdapter.INSTANCE.getConclusionDocument())) continue;
                    ontology = TPTPConverter.getOntology(doc);
                    renderer = new Renderer();
                    renderer.setNegate(true);
                    renderer.renderOntology(ontology, (Writer)fw, names, strings, integers, others, types);
                }
                fw.close();
            }
        }
        catch (Renderer.BigCardinalityException ex) {
            fw.close();
            fw = new FileWriter(fname);
            PrintWriter pw = new PrintWriter(fw);
            pw.println("% BigCardinality");
            pw.println("% This file is empty as the source KB involved");
            pw.println("% a large cardinality expression.");
            pw.println("% " + ex.getMessage());
            fw.close();
        }
    }

    public static OWLOntology getOntology(String uriString) throws Exception {
        URI uri = new URI(uriString);
        boolean neg = false;
        OWLRDFParser parser = new OWLRDFParser();
        parser.setConnection(OWLManager.getOWLConnection());
        OWLRDFErrorHandler handler = new OWLRDFErrorHandler(){

            public void owlFullConstruct(int code, String message) throws SAXException {
                System.err.println("WARNING -- OWL Full: " + message);
            }

            public void owlFullConstruct(int code, String message, Object obj) throws SAXException {
                System.err.println("WARNING -- OWL Full: " + message);
            }

            public void error(String message) throws SAXException {
                throw new SAXException("error: " + message);
            }

            public void warning(String message) throws SAXException {
            }
        };
        parser.setOWLRDFErrorHandler(handler);
        OWLOntology onto = parser.parseOntology(uri);
        return onto;
    }
}

