/*
 * Decompiled with CFR 0.152.
 */
package arq.cmd;

import arq.cmd.ResultsFormat;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.core.ARQConstants;
import com.hp.hpl.jena.query.resultset.PlainFormat;
import com.hp.hpl.jena.query.resultset.ResultSetApply;
import com.hp.hpl.jena.query.resultset.ResultSetProcessor;
import com.hp.hpl.jena.query.vocabulary.ResultSetGraphVocab;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import java.io.OutputStream;

public class QueryCmdUtils {
    protected static PrefixMapping globalPrefixMap = new PrefixMappingImpl();

    public static void executeQuery(Query query2, QueryExecution queryExecution, ResultsFormat outputFormat) {
        if (query2.isSelectType()) {
            QueryCmdUtils.doSelectQuery(query2, queryExecution, outputFormat);
        }
        if (query2.isDescribeType()) {
            QueryCmdUtils.doDescribeQuery(query2, queryExecution, outputFormat);
        }
        if (query2.isConstructType()) {
            QueryCmdUtils.doConstructQuery(query2, queryExecution, outputFormat);
        }
        if (query2.isAskType()) {
            QueryCmdUtils.doAskQuery(query2, queryExecution, outputFormat);
        }
        queryExecution.close();
    }

    public static void outputResultSet(ResultSet results, PrefixMapping prefixMapping, ResultsFormat outputFormat) {
        boolean done = false;
        if (prefixMapping == null) {
            prefixMapping = globalPrefixMap;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_UNKNOWN)) {
            outputFormat = ResultsFormat.FMT_RS_TEXT;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_NONE) || outputFormat.equals((Object)ResultsFormat.FMT_COUNT)) {
            int count = ResultSetFormatter.consume((ResultSet)results);
            if (outputFormat.equals((Object)ResultsFormat.FMT_COUNT)) {
                System.out.println("Count = " + count);
            }
            done = true;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_RS_RDF) || outputFormat.equals((Object)ResultsFormat.FMT_RDF_N3)) {
            Model m = ResultSetFormatter.toModel((ResultSet)results);
            m.setNsPrefixes(prefixMapping);
            RDFWriter rdfw = m.getWriter("TURTLE");
            m.setNsPrefix("rs", ResultSetGraphVocab.getURI());
            rdfw.write(m, (OutputStream)System.out, null);
            done = true;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_RS_XML)) {
            ResultSetFormatter.outputAsXML((OutputStream)System.out, (ResultSet)results);
            done = true;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_RS_JSON)) {
            ResultSetFormatter.outputAsJSON((OutputStream)System.out, (ResultSet)results);
            done = true;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_RS_TEXT)) {
            ResultSetFormatter.out((OutputStream)System.out, (ResultSet)results, (PrefixMapping)prefixMapping);
            done = true;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_TEXT)) {
            ResultSetFormatter.out((OutputStream)System.out, (ResultSet)results, (PrefixMapping)prefixMapping);
            done = true;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_TUPLES)) {
            PlainFormat pFmt = new PlainFormat((OutputStream)System.out, prefixMapping);
            ResultSetApply a = new ResultSetApply(results, (ResultSetProcessor)pFmt);
            a.apply();
            done = true;
        }
        if (!done) {
            System.err.println("Unknown format request: " + (Object)((Object)outputFormat));
        }
        results = null;
        System.out.flush();
    }

    private static void doSelectQuery(Query query2, QueryExecution qe, ResultsFormat outputFormat) {
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_RS_TEXT;
        }
        ResultSet results = qe.execSelect();
        QueryCmdUtils.outputResultSet(results, query2.getPrefixMapping(), outputFormat);
    }

    private static void doDescribeQuery(Query query2, QueryExecution qe, ResultsFormat outputFormat) {
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_RDF_TTL;
        }
        Model r = qe.execDescribe();
        QueryCmdUtils.writeModel(query2, r, outputFormat);
    }

    private static void doConstructQuery(Query query2, QueryExecution qe, ResultsFormat outputFormat) {
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_RDF_TTL;
        }
        Model r = qe.execConstruct();
        QueryCmdUtils.writeModel(query2, r, outputFormat);
    }

    private static void writeModel(Query query2, Model model, ResultsFormat outputFormat) {
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_RS_TEXT;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_NONE)) {
            return;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_TEXT)) {
            String qType = "";
            if (query2.isDescribeType()) {
                qType = "DESCRIBE";
            }
            if (query2.isConstructType()) {
                qType = "CONSTRUCT";
            }
            System.out.println("# ======== " + qType + " results ");
            model.write((OutputStream)System.out, "N3", null);
            System.out.println("# ======== ");
            return;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_RDF_XML)) {
            model.write((OutputStream)System.out, "RDF/XML-ABBREV", null);
            return;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_RDF_TTL)) {
            model.write((OutputStream)System.out, "N3", null);
            return;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_RDF_N3)) {
            model.write((OutputStream)System.out, "N3", null);
            return;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_RDF_NT)) {
            model.write((OutputStream)System.out, "N_TRIPLES", null);
            return;
        }
        System.err.println("Unknown format: " + outputFormat.getSymbol());
    }

    private static void doAskQuery(Query query2, QueryExecution qe, ResultsFormat outputFormat) {
        boolean b = qe.execAsk();
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_TEXT;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_RS_XML)) {
            ResultSetFormatter.outputAsXML((OutputStream)System.out, (boolean)b);
            return;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_RDF_N3) || outputFormat.equals((Object)ResultsFormat.FMT_RDF_TTL)) {
            ResultSetFormatter.outputAsRDF((OutputStream)System.out, (String)"TURTLE", (boolean)b);
            System.out.flush();
            return;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_RS_JSON)) {
            ResultSetFormatter.outputAsJSON((OutputStream)System.out, (boolean)b);
            return;
        }
        if (outputFormat.equals((Object)ResultsFormat.FMT_TEXT)) {
            System.out.println("Ask => " + (b ? "Yes" : "No"));
            return;
        }
        System.err.println("Unknown format: " + outputFormat.getSymbol());
    }

    static {
        globalPrefixMap.setNsPrefix("rdf", ARQConstants.rdfPrefix);
        globalPrefixMap.setNsPrefix("rdfs", ARQConstants.rdfsPrefix);
        globalPrefixMap.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        globalPrefixMap.setNsPrefix("rs", ResultSetGraphVocab.getURI());
    }
}

