/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import arq.cmdline.ModBase;
import com.hp.hpl.jena.query.engine2.QueryEngineQuad;
import com.hp.hpl.jena.query.engine2.QueryEngineRef;
import java.util.Iterator;
import java.util.List;

public class ModEngine
extends ModBase {
    protected final ArgDecl engineDecl = new ArgDecl(true, "engine");
    protected final ArgDecl unEngineDecl = new ArgDecl(true, "unengine", "unEngine", "removeEngine", "removeengine");
    private boolean timing = false;

    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Query Engine");
        cmdLine.add(this.engineDecl, "--engine=EngineName", "Register another engine factory[ref]");
        cmdLine.add(this.unEngineDecl, "--unengine=EngineName", "Unregister an engine factory");
    }

    public void checkCommandLine(CmdGeneral cmdLine) {
    }

    public void processArgs(CmdArgModule cmdLine) {
        List x = cmdLine.getValues(this.engineDecl);
        Iterator iter = x.iterator();
        while (iter.hasNext()) {
            String engineName = (String)iter.next();
            if (engineName.equalsIgnoreCase("engine2") || engineName.equalsIgnoreCase("ref") || engineName.equalsIgnoreCase("reference")) {
                QueryEngineRef.register();
                continue;
            }
            if (engineName.equalsIgnoreCase("quad")) {
                QueryEngineQuad.register();
                continue;
            }
            throw new CmdException("Engine name not recognized: " + engineName);
        }
        List y = cmdLine.getValues(this.unEngineDecl);
        Iterator iter2 = y.iterator();
        while (iter2.hasNext()) {
            String engineName = (String)iter2.next();
            if (engineName.equalsIgnoreCase("engine2") || engineName.equalsIgnoreCase("ref") || engineName.equalsIgnoreCase("reference")) {
                QueryEngineRef.unregister();
                continue;
            }
            if (engineName.equalsIgnoreCase("quad")) {
                QueryEngineQuad.unregister();
                continue;
            }
            throw new CmdException("Engine name not recognized: " + engineName);
        }
    }
}

