/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmdline.ArgDecl;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import arq.cmdline.HelpCallback;
import arq.cmdline.ModBase;

public class ModGeneral
extends ModBase {
    private HelpCallback helpCallback = null;
    private final ArgDecl argDeclHelp = new ArgDecl(false, "help", "h");
    private final ArgDecl argDeclVerbose = new ArgDecl(false, "v", "verbose");
    private final ArgDecl argDeclQuiet = new ArgDecl(false, "q", "quiet");
    private final ArgDecl argDeclDebug = new ArgDecl(false, "debug");
    protected boolean verbose = false;
    protected boolean quiet = false;
    protected boolean debug = false;
    protected boolean help = false;

    public ModGeneral(HelpCallback callback) {
        this.helpCallback = callback;
    }

    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("General");
        cmdLine.add(this.argDeclVerbose, "-v   --verbose", "Verbose");
        cmdLine.add(this.argDeclQuiet, "-q   --quiet", "Run with minimal output");
        cmdLine.add(this.argDeclDebug, "--debug", "Output information for debugging");
        cmdLine.add(this.argDeclHelp, "--help", null);
    }

    public void processArgs(CmdArgModule cmdLine) {
        this.verbose = cmdLine.contains(this.argDeclVerbose);
        this.quiet = cmdLine.contains(this.argDeclQuiet);
        this.debug = cmdLine.contains(this.argDeclDebug);
        if (this.debug) {
            this.verbose = true;
        }
        this.help = cmdLine.contains(this.argDeclHelp);
        if (this.help) {
            this.helpCallback.doHelp();
        }
    }
}

