/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.lang.Parser;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import java.io.OutputStream;

public class ModQueryOut
implements ArgModuleGeneral {
    protected final ArgDecl queryOutputSyntaxDecl = new ArgDecl(true, "out", "format");
    protected final ArgDecl queryNumberDecl = new ArgDecl(true, "num", "number");
    protected final ArgDecl queryPlainDecl = new ArgDecl(false, "plain");
    private Syntax outputSyntax = Syntax.syntaxSPARQL;
    private boolean lineNumbers = true;

    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Output");
        cmdLine.add(this.queryOutputSyntaxDecl, "--out, --format", "Output syntax");
        cmdLine.add(this.queryNumberDecl, "--num [on|off]", "Numbers");
        cmdLine.add(this.queryPlainDecl, "--plain", "Plain output");
    }

    public void processArgs(CmdArgModule cmdline) throws IllegalArgumentException {
        if (cmdline.contains(this.queryOutputSyntaxDecl)) {
            String s = cmdline.getValue(this.queryOutputSyntaxDecl);
            Syntax syn = Syntax.lookup((String)s);
            if (syn == null) {
                cmdline.cmdError("Unrecognized syntax: " + s);
            }
            this.outputSyntax = syn;
        }
        if (cmdline.contains(this.queryNumberDecl)) {
            this.lineNumbers = cmdline.getValue(this.queryNumberDecl).equalsIgnoreCase("on");
        }
        if (cmdline.contains(this.queryPlainDecl)) {
            this.lineNumbers = false;
        }
    }

    public Syntax getOutputSyntax() {
        return this.outputSyntax;
    }

    public void output(Query query2) {
        IndentedWriter w = new IndentedWriter((OutputStream)System.out, this.lineNumbers);
        query2.serialize(w, this.outputSyntax);
        w.flush();
    }

    public void checkParse(Query query2) {
        if (!Parser.canParse((Syntax)this.outputSyntax)) {
            return;
        }
        IndentedLineBuffer buff = new IndentedLineBuffer();
        query2.serialize(buff, this.outputSyntax);
        String tmp = buff.toString();
        Query query22 = null;
        try {
            String baseURI = null;
            if (!query2.explicitlySetBaseURI()) {
                baseURI = query2.getBaseURI();
            }
            if ((query22 = QueryFactory.create((String)tmp, (String)baseURI, (Syntax)this.outputSyntax)) == null) {
                return;
            }
        }
        catch (UnsupportedOperationException ex) {
            return;
        }
        catch (QueryException ex) {
            System.out.println();
            System.out.println("**** Check failed : could not parse output query:: ");
            System.out.println("**** " + ex.getMessage());
            return;
        }
        if (query2.hashCode() != query22.hashCode()) {
            System.out.println();
            System.out.println("**** Check failed : reparsed query hashCode does not equal parsed input query");
        }
        if (!query2.equals((Object)query22)) {
            System.out.println();
            System.out.println("**** Check failed : reparsed output does not equal parsed input");
            return;
        }
    }
}

