/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import java.text.DecimalFormat;

public class ModTime
implements ArgModuleGeneral {
    protected final ArgDecl timeDecl = new ArgDecl(false, "time");
    private boolean timing = false;
    protected boolean inTimer = false;
    protected long timeStart = 0L;
    protected long timeFinish = -1L;

    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Time");
        cmdLine.add(this.timeDecl, "--time", "Time the operation");
    }

    public void checkCommandLine(CmdArgModule cmdLine) {
    }

    public void processArgs(CmdArgModule cmdLine) {
        this.timing = cmdLine.contains(this.timeDecl);
    }

    public boolean timingEnabled() {
        return this.timing;
    }

    public void setTimingEnabled(boolean timingEnabled) {
        this.timing = timingEnabled;
    }

    public void startTimer() {
        if (this.inTimer) {
            throw new CmdException("Already in timer");
        }
        this.timeStart = System.currentTimeMillis();
        this.timeFinish = -1L;
        this.inTimer = true;
    }

    public long endTimer() {
        if (!this.inTimer) {
            throw new CmdException("Not in timer");
        }
        this.timeFinish = System.currentTimeMillis();
        this.inTimer = false;
        return this.getTimeInterval();
    }

    public long readTimer() {
        if (!this.inTimer) {
            throw new CmdException("Not in timer");
        }
        return System.currentTimeMillis() - this.timeStart;
    }

    public long getTimeInterval() {
        if (this.inTimer) {
            throw new CmdException("Still timing");
        }
        if (this.timeFinish == -1L) {
            throw new CmdException("No valid interval");
        }
        return this.timeFinish - this.timeStart;
    }

    public String timeStr(long timeInterval) {
        DecimalFormat f = new DecimalFormat("#0.###");
        String s = f.format((double)timeInterval / 1000.0);
        return s;
    }

    protected String timeStr(long timePoint, long startTimePoint) {
        return this.timeStr(timePoint - startTimePoint);
    }
}

