/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdException;
import arq.cmd.CmdUtils;
import arq.cmd.TerminationException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdLineArgs;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.core.ARQConstants;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine.BindingMap;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.util.ExprUtils;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.io.PrintStream;

public class qexpr {
    public static void main(String[] argv) {
        block3: {
            try {
                qexpr.main2(argv);
            }
            catch (TerminationException ex) {
                System.exit(ex.getCode());
            }
            catch (CmdException ex) {
                System.err.println(ex.getMessage());
                if (ex.getCause() == null) break block3;
                ex.getCause().printStackTrace(System.err);
            }
        }
    }

    public static void main2(String[] argv) {
        CmdLineArgs cl = new CmdLineArgs(argv);
        ArgDecl helpDecl = new ArgDecl(false, "h", "help");
        cl.add(helpDecl);
        ArgDecl verboseDecl = new ArgDecl(false, "v", "verbose");
        cl.add(verboseDecl);
        ArgDecl versionDecl = new ArgDecl(false, "ver", "version", "V");
        cl.add(versionDecl);
        ArgDecl quietDecl = new ArgDecl(false, "q", "quiet");
        cl.add(quietDecl);
        ArgDecl reduceDecl = new ArgDecl(false, "reduce", "fold", "simplify");
        cl.add(reduceDecl);
        ArgDecl printSPARQL = new ArgDecl(false, "print");
        cl.add(printSPARQL);
        ArgDecl printPrefix = new ArgDecl(false, "prefix", "printPrefix", "printprefix");
        cl.add(printPrefix);
        try {
            cl.process();
        }
        catch (IllegalArgumentException ex) {
            System.err.println(ex.getMessage());
            qexpr.usage(System.err);
            throw new CmdException();
        }
        if (cl.contains(helpDecl)) {
            qexpr.usage();
            throw new TerminationException(0);
        }
        if (cl.contains(versionDecl)) {
            System.out.println("ARQ Version: 1.5.1 (Jena: 2.5.1)");
            throw new TerminationException(0);
        }
        boolean verbose = cl.contains(verboseDecl);
        boolean quiet = cl.contains(quietDecl);
        boolean actionCopySubstitute = cl.contains(reduceDecl);
        boolean actionPrintSPARQL = cl.contains(printSPARQL);
        boolean actionPrintPrefix = cl.contains(printPrefix);
        for (int i = 0; i < cl.getNumPositional(); ++i) {
            String exprStr = cl.getPositionalArg(i);
            exprStr = cl.indirect(exprStr);
            try {
                PrefixMapping pmap = PrefixMapping.Factory.create();
                pmap.setNsPrefixes(ARQConstants.getGlobalPrefixMap());
                pmap.setNsPrefix("", "http://example/");
                pmap.setNsPrefix("ex", "http://example/ns#");
                Expr expr = ExprUtils.parse((String)exprStr, (PrefixMapping)pmap);
                if (verbose) {
                    System.out.print(expr.toString() + " => ");
                }
                try {
                    if (actionCopySubstitute) {
                        Expr e = expr.copySubstitute((Binding)new BindingMap(), true);
                        System.out.println(e.toString());
                        continue;
                    }
                    if (actionPrintSPARQL) {
                        System.out.println(ExprUtils.fmtSPARQL((Expr)expr));
                        continue;
                    }
                    if (actionPrintPrefix) {
                        System.out.println(ExprUtils.fmtPrefix((Expr)expr));
                        continue;
                    }
                    NodeValue r = expr.eval(null, null);
                    Node n = r.asNode();
                    String s = FmtUtils.stringForNode((Node)n);
                    System.out.println(s);
                    continue;
                }
                catch (ExprEvalException ex) {
                    System.out.println("Exception: " + ex.getMessage());
                    throw new TerminationException(2);
                }
            }
            catch (QueryParseException ex) {
                System.err.println("Parse error: " + ex.getMessage());
                throw new TerminationException(2);
            }
        }
    }

    static void usage() {
        qexpr.usage(System.out);
    }

    static void usage(PrintStream out) {
        out.println("Usage: expression");
    }

    static {
        CmdUtils.setLog4j();
        CmdUtils.setN3Params();
    }
}

