/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdARQ;
import arq.cmdline.ModQueryIn;
import arq.cmdline.ModQueryOut;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.resultset.ResultSetException;
import com.hp.hpl.jena.query.util.QueryUtils;
import com.hp.hpl.jena.query.util.Utils;
import com.hp.hpl.jena.shared.JenaException;
import java.io.PrintStream;
import java.util.Iterator;

public class qparse
extends CmdARQ {
    ModQueryIn modQuery = new ModQueryIn();
    ModQueryOut modOutput = new ModQueryOut();
    protected final ArgDecl argDeclPrint = new ArgDecl(true, "print");
    boolean printQuery = false;
    boolean printOp = false;
    boolean printQuad = false;
    boolean printPlan = false;
    static String usage = qparse.class.getName() + " [--in syntax] [--out syntax] [--print=FORM] [\"query\"] | --query <file>";
    static final String divider = "";
    boolean needDivider = false;

    public static void main(String[] argv) {
        new qparse(argv).mainAndExit();
    }

    protected qparse(String[] argv) {
        super(argv);
        super.addModule(this.modQuery);
        super.addModule(this.modOutput);
        super.getUsage().startCategory(null);
        super.add(this.argDeclPrint, "--print", "Print in various forms [query, op, quad]");
    }

    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        Iterator iter = this.getValues(this.argDeclPrint).iterator();
        while (iter.hasNext()) {
            String arg = (String)iter.next();
            if (arg.equalsIgnoreCase("query")) {
                this.printQuery = true;
                continue;
            }
            if (arg.equalsIgnoreCase("op")) {
                this.printOp = true;
                continue;
            }
            if (arg.equalsIgnoreCase("quad")) {
                this.printQuad = true;
                continue;
            }
            if (arg.equalsIgnoreCase("plan")) {
                this.printPlan = true;
                continue;
            }
            throw new CmdException("Not a recognized print form: " + arg + " : Choices are: query, op, quad");
        }
        if (!(this.printQuery || this.printOp || this.printQuad || this.printPlan)) {
            this.printQuery = true;
        }
    }

    protected String getSummary() {
        return usage;
    }

    private void divider() {
        if (this.needDivider) {
            System.out.println(divider);
        }
        this.needDivider = true;
    }

    protected void exec() {
        try {
            Query query2 = this.modQuery.getQuery();
            this.modOutput.checkParse(query2);
            if (this.printOp) {
                this.divider();
                QueryUtils.printOp((Query)query2);
            }
            if (this.printQuad) {
                this.divider();
                QueryUtils.printQuad((Query)query2);
            }
            if (this.printPlan) {
                this.divider();
                QueryUtils.printPlan((Query)query2);
            }
            if (this.printQuery) {
                this.modOutput.output(query2);
            }
        }
        catch (ARQInternalErrorException intEx) {
            System.err.println(intEx.getMessage());
            if (intEx.getCause() != null) {
                System.err.println("Cause:");
                intEx.getCause().printStackTrace(System.err);
                System.err.println();
            }
            intEx.printStackTrace(System.err);
        }
        catch (ResultSetException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
        }
        catch (QueryException qEx) {
            throw new CmdException("Query Exeception", qEx);
        }
        catch (JenaException ex) {
            throw ex;
        }
        catch (CmdException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CmdException("Exception", ex);
        }
    }

    protected String getCommandName() {
        return Utils.className((Object)this);
    }

    static void writeSyntaxes(String msg, PrintStream out) {
        if (msg != null) {
            out.println(msg);
        }
        Iterator iter = Syntax.querySyntaxNames.keys();
        while (iter.hasNext()) {
            String k = (String)iter.next();
            Syntax v = Syntax.lookup((String)k);
            k = qparse.padOut(k, 10);
            out.println("  " + k + "  " + v);
        }
    }

    static String padOut(String x, int len) {
        StringBuffer r = new StringBuffer(x);
        for (int i = x.length(); i <= len; ++i) {
            r.append(" ");
        }
        return r.toString();
    }
}

