/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.junit;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.junit.QueryTestException;
import com.hp.hpl.jena.query.junit.TestCaseARQ;
import com.hp.hpl.jena.query.junit.TestItem;
import com.hp.hpl.jena.query.resultset.ResultSetRewindable;
import com.hp.hpl.jena.query.util.DatasetUtils;
import com.hp.hpl.jena.query.util.GraphUtils;
import com.hp.hpl.jena.query.util.Symbol;
import com.hp.hpl.jena.query.vocabulary.ResultSetGraphVocab;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryTest
extends TestCaseARQ {
    private static Log log = LogFactory.getLog((Class)QueryTest.class);
    private static int testCounter = 1;
    private static boolean printModelsOnFailure = false;
    Model model;
    int testNumber = testCounter++;
    TestItem testItem;
    FileManager queryFileManager;
    boolean isRDQLtest = false;
    boolean resetNeeded = false;
    Model resultsModel = null;
    String _description = null;

    public QueryTest(Model m, String testName, FileManager fm, TestItem t) {
        super(QueryTest.fixName(testName));
        this.model = m;
        this.queryFileManager = fm;
        this.testItem = t;
        this.isRDQLtest = this.testItem.getQueryFileSyntax().equals((Object)Syntax.syntaxRDQL);
    }

    private static String fixName(String s) {
        s = s.replace('(', '[');
        s = s.replace(')', ']');
        return s;
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.isRDQLtest) {
            this.resetNeeded = true;
            ARQ.setTrue((Symbol)ARQ.graphNoSameValueAs);
        }
        this.resultsModel = this.constructResultsModel(this.testItem.getResultFile());
    }

    protected void tearDown() throws Exception {
        if (this.resetNeeded) {
            ARQ.setFalse((Symbol)ARQ.graphNoSameValueAs);
        }
        super.tearDown();
    }

    private Model constructResultsModel(String filename) {
        if (filename == null) {
            return null;
        }
        Model model = GraphUtils.makeJenaDefaultModel();
        ResultSetFactory.loadAsModel((Model)model, (String)filename);
        return model;
    }

    private Dataset setUpDataset(Query query2, TestItem testItem) {
        try {
            if (QueryTest.doesQueryHaveDataset(query2) && QueryTest.doesTestItemHaveDataset(testItem) && testItem.getResultFile() != null) {
                log.warn((Object)(testItem.getName() + " : query data source and also in test file"));
            }
            if (QueryTest.doesTestItemHaveDataset(testItem)) {
                return QueryTest.createDataset(testItem.getDefaultGraphURIs(), testItem.getNamedGraphURIs());
            }
            if (!QueryTest.doesQueryHaveDataset(query2)) {
                QueryTest.fail((String)"No dataset");
            }
            return null;
        }
        catch (JenaException jEx) {
            log.debug((Object)("JenaException: " + jEx.getMessage()));
            QueryTest.fail((String)("JenaException creating data source: " + jEx.getMessage()));
            return null;
        }
    }

    private static boolean doesTestItemHaveDataset(TestItem testItem) {
        boolean r = testItem.getDefaultGraphURIs() != null && testItem.getDefaultGraphURIs().size() > 0 || testItem.getNamedGraphURIs() != null && testItem.getNamedGraphURIs().size() > 0;
        return r;
    }

    private static boolean doesQueryHaveDataset(Query query2) {
        boolean r = query2.getGraphURIs() != null && query2.getGraphURIs().size() > 0 || query2.getNamedGraphURIs() != null && query2.getNamedGraphURIs().size() > 0;
        return r;
    }

    private static Dataset createDataset(List defaultGraphURIs, List namedGraphURIs) {
        return DatasetUtils.createDataset((List)defaultGraphURIs, (List)namedGraphURIs, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Throwable {
        Query query2 = null;
        try {
            if (this.testItem.getQueryFile() == null) {
                QueryTest.fail((String)"Query test file is null");
                return;
            }
            try {
                query2 = QueryFactory.read((String)this.testItem.getQueryFile(), null, (Syntax)this.testItem.getQueryFileSyntax());
            }
            catch (QueryException qEx) {
                query2 = null;
                QueryTest.fail((String)("Parse failure: " + qEx.getMessage()));
                throw qEx;
            }
            Dataset dataset = this.setUpDataset(query2, this.testItem);
            if (dataset == null && !QueryTest.doesQueryHaveDataset(query2)) {
                QueryTest.fail((String)"No dataset for query");
            }
            QueryExecution qe = null;
            QueryExecutionFactory.create((Query)query2, (FileManager)this.queryFileManager);
            qe = dataset == null ? QueryExecutionFactory.create((Query)query2) : QueryExecutionFactory.create((Query)query2, (Dataset)dataset);
            if (this.queryFileManager != null) {
                qe.setFileManager(this.queryFileManager);
            }
            try {
                if (query2.isSelectType()) {
                    this.runTestSelect(query2, qe);
                } else if (query2.isConstructType()) {
                    this.runTestConstruct(query2, qe);
                } else if (query2.isDescribeType()) {
                    this.runTestDescribe(query2, qe);
                } else if (query2.isAskType()) {
                    this.runTestAsk(query2, qe);
                }
            }
            finally {
                qe.close();
            }
        }
        catch (IOException ioEx) {
            QueryTest.fail((String)("IOException: " + ioEx.getMessage()));
            throw ioEx;
        }
        catch (NullPointerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.debug((Object)("Exception: " + ex.getMessage()), (Throwable)ex);
            ex.printStackTrace(System.err);
            QueryTest.fail((String)("Exception: " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    void runTestSelect(Query query2, QueryExecution qe) throws Exception {
        ResultSet resultsActual = qe.execSelect();
        ResultSetRewindable results = ResultSetFactory.makeRewindable((ResultSet)resultsActual);
        qe.close();
        resultsActual = null;
        this.checkResults(query2, results, this.resultsModel);
    }

    private void checkResults(Query query2, ResultSetRewindable results, Model resultsModel) {
        if (resultsModel == null) {
            return;
        }
        try {
            ResultSetRewindable qr1 = ResultSetFactory.makeRewindable((ResultSet)results);
            ResultSetRewindable qr2 = ResultSetFactory.makeRewindable((Model)resultsModel);
            boolean b = QueryTest.resultSetEquivalent(query2, (ResultSet)qr1, (ResultSet)qr2);
            if (!b) {
                this.printFailedResultSetTest(query2, qr1, qr2);
            }
            QueryTest.assertTrue((String)("Results do not match: " + this.testItem.getName()), (boolean)b);
        }
        catch (Exception ex) {
            log.warn((Object)"Exception in result testing", (Throwable)ex);
            QueryTest.fail((String)("Exception in result testing: " + ex));
        }
    }

    private static Model resultSetToModel(ResultSet rs) {
        Model m = GraphUtils.makeDefaultModel();
        ResultSetFormatter.asRDF((Model)m, (ResultSet)rs);
        if (m.getNsPrefixURI("rs") == null) {
            m.setNsPrefix("rs", ResultSetGraphVocab.getURI());
        }
        if (m.getNsPrefixURI("rdf") == null) {
            m.setNsPrefix("rdf", RDF.getURI());
        }
        if (m.getNsPrefixURI("xsd") == null) {
            m.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        }
        return m;
    }

    public static boolean resultSetEquivalent(Query query2, ResultSet rs1, ResultSet rs2) {
        Model model2 = QueryTest.resultSetToModel(rs2);
        return QueryTest.resultSetEquivalent(query2, rs1, model2);
    }

    public static boolean resultSetEquivalent(Query query2, ResultSet rs1, Model model2) {
        Model model1 = QueryTest.resultSetToModel(rs1);
        return model1.isIsomorphicWith(model2);
    }

    void runTestConstruct(Query query2, QueryExecution qe) throws Exception {
        Model resultsActual = qe.execConstruct();
        if (this.resultsModel != null) {
            try {
                if (!this.resultsModel.isIsomorphicWith(resultsActual)) {
                    this.printFailedModelTest(query2, resultsActual, this.resultsModel);
                    QueryTest.fail((String)("Results do not match: " + this.testItem.getName()));
                }
            }
            catch (Exception ex) {
                log.warn((Object)"Exception in result testing (construct)", (Throwable)ex);
                QueryTest.fail((String)("Exception in result testing: " + ex));
            }
        }
    }

    void runTestDescribe(Query query2, QueryExecution qe) throws Exception {
        Model resultsActual = qe.execDescribe();
        if (this.resultsModel != null) {
            try {
                if (!this.resultsModel.isIsomorphicWith(resultsActual)) {
                    this.printFailedModelTest(query2, resultsActual, this.resultsModel);
                    QueryTest.fail((String)("Results do not match: " + this.testItem.getName()));
                }
            }
            catch (Exception ex) {
                log.warn((Object)"Exception in result testing (describe)", (Throwable)ex);
                QueryTest.fail((String)("Exception in result testing: " + ex));
            }
        }
    }

    void runTestAsk(Query query2, QueryExecution qe) throws Exception {
        boolean result = qe.execAsk();
        if (this.resultsModel != null) {
            Property p;
            StmtIterator sIter = this.resultsModel.listStatements(null, RDF.type, (RDFNode)ResultSetGraphVocab.ResultSet);
            if (!sIter.hasNext()) {
                throw new QueryTestException("Can't find the ASK result");
            }
            Statement s = sIter.nextStatement();
            if (sIter.hasNext()) {
                throw new QueryTestException("Too many result sets in ASK result");
            }
            Resource r = s.getSubject();
            boolean x = r.getRequiredProperty(p = this.resultsModel.createProperty(ResultSetGraphVocab.getURI() + "boolean")).getBoolean();
            if (x != result) {
                QueryTest.assertEquals((String)"ASK test results do not match", (boolean)x, (boolean)result);
            }
        }
    }

    void printFailedResultSetTest(Query query2, ResultSetRewindable qr1, ResultSetRewindable qr2) {
        PrintStream out = System.out;
        out.println();
        out.println("=======================================");
        out.println("Failure: " + this.description());
        out.println("Got: " + qr1.size() + " --------------------------------");
        qr1.reset();
        ResultSetFormatter.out((OutputStream)out, (ResultSet)qr1, (PrefixMapping)query2.getPrefixMapping());
        qr1.reset();
        if (printModelsOnFailure) {
            out.println("-----------------------------------------");
            QueryTest.resultSetToModel((ResultSet)qr1).write((OutputStream)out, "N3");
            qr1.reset();
        }
        out.flush();
        out.println("Expected: " + qr2.size() + " -----------------------------");
        qr2.reset();
        ResultSetFormatter.out((OutputStream)out, (ResultSet)qr2, (PrefixMapping)query2.getPrefixMapping());
        qr2.reset();
        if (printModelsOnFailure) {
            out.println("---------------------------------------");
            QueryTest.resultSetToModel((ResultSet)qr2).write((OutputStream)out, "N3");
            qr2.reset();
        }
        out.println();
        out.flush();
    }

    void printFailedModelTest(Query query2, Model results, Model expected) {
        PrintWriter out = FileUtils.asPrintWriterUTF8((OutputStream)System.out);
        out.println("=======================================");
        out.println("Failure: " + this.description());
        if (printModelsOnFailure) {
            results.write((Writer)out, "N3");
            out.println("---------------------------------------");
            expected.write((Writer)out, "N3");
        }
        out.println();
    }

    public String toString() {
        if (this.testItem.getName() != null) {
            return this.testItem.getName();
        }
        return super.getName();
    }

    private String description() {
        if (this._description == null) {
            this._description = this.makeDescription();
        }
        return this._description;
    }

    private String makeDescription() {
        Iterator iter;
        String tmp = "";
        if (this.testItem.getDefaultGraphURIs() != null) {
            iter = this.testItem.getDefaultGraphURIs().iterator();
            while (iter.hasNext()) {
                tmp = tmp + (String)iter.next();
            }
        }
        if (this.testItem.getNamedGraphURIs() != null) {
            iter = this.testItem.getNamedGraphURIs().iterator();
            while (iter.hasNext()) {
                tmp = tmp + (String)iter.next();
            }
        }
        String d = "Test " + this.testNumber + " :: " + this.testItem.getName();
        return d;
    }
}

