/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.junit;

import com.hp.hpl.jena.query.DataFormat;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.junit.QueryTest;
import com.hp.hpl.jena.query.junit.QueryTestException;
import com.hp.hpl.jena.query.junit.SerializerTest;
import com.hp.hpl.jena.query.junit.SurpressedTest;
import com.hp.hpl.jena.query.junit.SyntaxTest;
import com.hp.hpl.jena.query.junit.TestFactory;
import com.hp.hpl.jena.query.junit.TestItem;
import com.hp.hpl.jena.query.junit.TestUtils;
import com.hp.hpl.jena.query.vocabulary.TestManifest;
import com.hp.hpl.jena.query.vocabulary.TestManifestX;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.FileManager;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class QueryTestSuiteFactory
extends TestFactory {
    private FileManager fileManager = FileManager.get();
    private Model model = null;

    public static TestSuite make(String filename) {
        QueryTestSuiteFactory tFact = new QueryTestSuiteFactory();
        return tFact.process(filename);
    }

    public static TestSuite make(String query2, String data, String result) {
        TestItem item = new TestItem(query2, query2, data, result);
        QueryTest t = new QueryTest(null, item.getName(), FileManager.get(), item);
        TestSuite ts = new TestSuite();
        ts.setName(TestUtils.safeName(query2));
        ts.addTest((Test)t);
        return ts;
    }

    public Test makeTest(Resource manifest, Resource entry, String testName, Resource action, Resource result) {
        Syntax querySyntax = TestUtils.getQuerySyntax(manifest);
        if (!(querySyntax == null || querySyntax.equals((Object)Syntax.syntaxRDQL) || querySyntax.equals((Object)Syntax.syntaxARQ) || querySyntax.equals((Object)Syntax.syntaxSPARQL))) {
            throw new QueryTestException("Unknown syntax: " + querySyntax);
        }
        Resource defaultTestType = TestUtils.getResource(manifest, TestManifestX.defaultTestType);
        TestItem item = new TestItem(entry, defaultTestType, querySyntax, DataFormat.langXML);
        TestCase test = null;
        if (item.getTestType() != null) {
            if (item.getTestType().equals(TestManifest.PositiveSyntaxTest) || item.getTestType().equals(TestManifestX.TestSyntax)) {
                test = new SyntaxTest(testName, item);
            }
            if (item.getTestType().equals(TestManifest.NegativeSyntaxTest) || item.getTestType().equals(TestManifestX.TestBadSyntax)) {
                test = new SyntaxTest(testName, item, false);
            }
            if (item.getTestType().equals(TestManifestX.TestSerialization)) {
                test = new SerializerTest(testName, item);
            }
            if (item.getTestType().equals(TestManifest.QueryEvaluationTest) || item.getTestType().equals(TestManifestX.TestQuery)) {
                test = new QueryTest(this.model, testName, this.fileManager, item);
            }
            if (item.getTestType().equals(TestManifestX.TestSurpressed)) {
                test = new SurpressedTest(testName, item.getComment());
            }
            if (test == null) {
                System.err.println("Test type '" + item.getTestType() + "' not recognized");
            }
        }
        if (test == null) {
            test = new QueryTest(this.model, testName, this.fileManager, item);
        }
        return test;
    }
}

