/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.junit;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine.BindingMap;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.lang.sparql.ParseException;
import com.hp.hpl.jena.query.lang.sparql.SPARQLParser;
import com.hp.hpl.jena.query.lang.sparql.TokenMgrError;
import com.hp.hpl.jena.query.util.ExprUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;

public abstract class TestExpr
extends TestCase {
    public static final int NO_FAILURE = 100;
    public static final int PARSE_FAIL = 250;
    public static final int EVAL_FAIL = 200;
    String testName;
    String exprString;
    Query query;
    Binding binding;
    int failureMode;
    boolean doEval;
    ExecutionContext execCxt = new ExecutionContext(ARQ.getContext());

    protected TestExpr(String label, String expression, Query queryCxt, Binding env, int failureOutcome) {
        this.testName = label;
        this.doEval = true;
        String n = label.replace('(', '[').replace(')', ']');
        switch (failureOutcome) {
            case 100: {
                break;
            }
            case 250: {
                n = n + " [Parse fail]";
                break;
            }
            case 200: {
                n = n + " [Eval fail]";
                break;
            }
            default: {
                n = n + " [Unknown fail]";
            }
        }
        this.setName(n);
        this.exprString = expression;
        if (queryCxt == null) {
            queryCxt = QueryFactory.make();
        }
        this.query = queryCxt;
        if (env == null) {
            env = new BindingMap();
        }
        this.binding = env;
        this.failureMode = failureOutcome;
    }

    protected void runTest() throws Throwable {
        Expr expr = null;
        try {
            expr = this.parse(this.exprString);
        }
        catch (Error err) {
            TestExpr.fail((String)("Error thrown in parse: " + err));
        }
        catch (Exception ex) {
            if (this.failureMode != 250) {
                TestExpr.fail((String)("Unexpected parsing failure: " + ex));
            }
            this.checkException(expr, ex);
            return;
        }
        if (this.failureMode == 250) {
            TestExpr.fail((String)("Test should have failed in parsing: " + expr));
            return;
        }
        Expr expr2 = expr.deepCopy();
        if (!expr.equals(expr2)) {
            System.out.println("Expr:  " + expr);
            System.out.println("Expr2: " + expr2);
            TestExpr.assertEquals((Object)expr, (Object)expr2);
        }
        this.checkExpr(expr);
        if (!this.doEval) {
            return;
        }
        try {
            NodeValue v = expr.eval(this.binding, this.execCxt);
            this.checkValue(expr, v);
        }
        catch (NullPointerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.checkException(expr, ex);
        }
    }

    private Expr parse(String exprString) throws Throwable {
        return ExprUtils.parse((Query)this.query, (String)exprString, (boolean)false);
    }

    private Expr parseSPARQL(ByteArrayInputStream in) throws Throwable {
        try {
            SPARQLParser parser = new SPARQLParser((InputStream)in);
            parser.setQuery(this.query);
            return parser.Expression();
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            throw new QueryParseException(tErr.getMessage(), -1, -1);
        }
        catch (Error err) {
            String tmp = err.getMessage();
            if (tmp == null) {
                throw new QueryParseException((Throwable)err, -1, -1);
            }
            throw new QueryParseException(tmp, -1, -1);
        }
    }

    protected boolean failureCorrect() {
        return this.failureMode != 100;
    }

    protected boolean evalCorrect() {
        return this.failureMode != 200;
    }

    abstract void checkExpr(Expr var1);

    abstract void checkValue(Expr var1, NodeValue var2);

    abstract void checkException(Expr var1, Exception var2);

    public String toString() {
        return this.testName;
    }
}

