/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.junit;

import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.junit.QueryTestException;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.vocabulary.TestManifestX;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;

public class TestUtils {
    public static boolean hasQuerySyntax(Resource r) {
        return r.hasProperty(TestManifestX.querySyntax);
    }

    public static Syntax getQuerySyntax(Resource r) {
        return Syntax.make((String)TestUtils.getLiteralOrURI(r, TestManifestX.querySyntax));
    }

    public static String getDataSyntax(Resource r) {
        return TestUtils.getLiteralOrURI(r, TestManifestX.dataSyntax);
    }

    public static Resource getResource(Resource r, Property p) {
        if (r == null) {
            return null;
        }
        if (!r.hasProperty(p)) {
            return null;
        }
        RDFNode n = r.getProperty(p).getObject();
        if (n instanceof Resource) {
            return (Resource)n;
        }
        throw new QueryTestException("Manifest problem (not a Resource): " + FmtUtils.stringForRDFNode((RDFNode)n) + " => " + FmtUtils.stringForRDFNode((RDFNode)p));
    }

    public static String getLiteral(Resource r, Property p) {
        if (r == null) {
            return null;
        }
        if (!r.hasProperty(p)) {
            return null;
        }
        RDFNode n = r.getProperty(p).getObject();
        if (n instanceof Literal) {
            return ((Literal)n).getLexicalForm();
        }
        throw new QueryTestException("Manifest problem (not a Literal): " + FmtUtils.stringForRDFNode((RDFNode)n) + " => " + FmtUtils.stringForRDFNode((RDFNode)p));
    }

    public static String getLiteralOrURI(Resource r, Property p) {
        Resource r2;
        if (r == null) {
            return null;
        }
        if (!r.hasProperty(p)) {
            return null;
        }
        RDFNode n = r.getProperty(p).getObject();
        if (n instanceof Literal) {
            return ((Literal)n).getLexicalForm();
        }
        if (n instanceof Resource && !(r2 = (Resource)n).isAnon()) {
            return r2.getURI();
        }
        throw new QueryTestException("Manifest problem: " + FmtUtils.stringForRDFNode((RDFNode)n) + " => " + FmtUtils.stringForRDFNode((RDFNode)p));
    }

    public static String safeName(String s) {
        s = s.replace('(', '[');
        s = s.replace(')', ']');
        return s;
    }
}

