/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.test;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.larq.IndexBuilderExt;
import com.hp.hpl.jena.query.larq.IndexBuilderModel;
import com.hp.hpl.jena.query.larq.IndexBuilderString;
import com.hp.hpl.jena.query.larq.IndexBuilderSubject;
import com.hp.hpl.jena.query.larq.IndexLARQ;
import com.hp.hpl.jena.query.larq.LARQ;
import com.hp.hpl.jena.query.resultset.RSCompare;
import com.hp.hpl.jena.query.resultset.ResultSetRewindable;
import com.hp.hpl.jena.query.util.Context;
import com.hp.hpl.jena.query.util.StringUtils;
import com.hp.hpl.jena.query.util.Utils;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestLARQ
extends TestCase {
    static final String datafile = "testing/LARQ/data-1.ttl";
    static final String results1 = "testing/LARQ/results-1.srj";
    static final String results2 = "testing/LARQ/results-2.srj";
    static final String results3 = "testing/LARQ/results-3.srj";

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestLARQ.class);
        ts.setName(Utils.classShortName((Class)TestLARQ.class));
        return ts;
    }

    public void test_ext_1() {
        IndexBuilderExt b = new IndexBuilderExt();
        Model model = ModelFactory.createDefaultModel();
        Resource r = model.createResource("http://example/r");
        b.index((RDFNode)r, "foo");
        b.closeForWriting();
        IndexLARQ index = b.getIndex();
        NodeIterator nIter = index.searchModelByIndex("foo");
        TestLARQ.assertEquals((int)1, (int)this.count((Iterator)nIter));
        nIter = index.searchModelByIndex("foo");
        Resource r2 = (Resource)nIter.nextNode();
        TestLARQ.assertEquals((Object)r, (Object)r2);
    }

    public void test_ext_2() {
        IndexBuilderExt b = new IndexBuilderExt();
        Model model = ModelFactory.createDefaultModel();
        Literal lit = model.createLiteral("example");
        b.index((RDFNode)lit, "foo");
        b.closeForWriting();
        IndexLARQ index = b.getIndex();
        NodeIterator nIter = index.searchModelByIndex("foo");
        TestLARQ.assertEquals((int)1, (int)this.count((Iterator)nIter));
        nIter = index.searchModelByIndex("foo");
        Literal lit2 = (Literal)nIter.nextNode();
        TestLARQ.assertEquals((Object)lit, (Object)lit2);
    }

    public void test_ext_3() {
        IndexBuilderExt b = new IndexBuilderExt();
        Model model = ModelFactory.createDefaultModel();
        Resource bnode = model.createResource();
        b.index((RDFNode)bnode, "foo");
        b.closeForWriting();
        IndexLARQ index = b.getIndex();
        NodeIterator nIter = index.searchModelByIndex("foo");
        TestLARQ.assertEquals((int)1, (int)this.count((Iterator)nIter));
        nIter = index.searchModelByIndex("foo");
        Resource bnode2 = (Resource)nIter.nextNode();
        TestLARQ.assertEquals((Object)bnode, (Object)bnode2);
        TestLARQ.assertTrue((boolean)bnode2.isAnon());
    }

    public void test_ext_4() {
        IndexBuilderExt b = new IndexBuilderExt();
        Model model = ModelFactory.createDefaultModel();
        Resource r = model.createResource("http://example/r");
        b.index((RDFNode)r, "foo");
        b.closeForWriting();
        IndexLARQ index = b.getIndex();
        NodeIterator nIter = index.searchModelByIndex("bah");
        TestLARQ.assertFalse((boolean)nIter.hasNext());
    }

    public void test_ext_5() {
        IndexBuilderExt b = new IndexBuilderExt();
        Model model = ModelFactory.createDefaultModel();
        Resource r = model.createResource("http://example/r");
        StringReader sr = new StringReader("foo");
        b.index((RDFNode)r, (Reader)sr);
        b.closeForWriting();
        IndexLARQ index = b.getIndex();
        NodeIterator nIter = index.searchModelByIndex("foo");
        TestLARQ.assertEquals((int)1, (int)this.count((Iterator)nIter));
        nIter = index.searchModelByIndex("foo");
        Resource r2 = (Resource)nIter.nextNode();
        TestLARQ.assertEquals((Object)r, (Object)r2);
    }

    public void test_index_literal_1() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQ.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString());
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        TestLARQ.assertEquals((int)3, (int)this.count((Iterator)nIter));
        index.close();
    }

    public void test_index_literal_2() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQ.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString(DC.title));
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        TestLARQ.assertEquals((int)2, (int)this.count((Iterator)nIter));
    }

    public void test_index_literal_3() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQ.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString());
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        while (nIter.hasNext()) {
            RDFNode n = nIter.nextNode();
            TestLARQ.assertTrue((boolean)(n instanceof Literal));
            TestLARQ.assertTrue((boolean)model.contains(null, null, n));
            boolean b = model.contains(null, DC.title, n) || model.contains(null, RDFS.label, n);
            TestLARQ.assertTrue((String)"DC.title or RDFS.label", (boolean)b);
        }
    }

    public void test_index_literal_4() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQ.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString(DC.title));
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        while (nIter.hasNext()) {
            RDFNode n = nIter.nextNode();
            TestLARQ.assertTrue((boolean)(n instanceof Literal));
            TestLARQ.assertTrue((boolean)model.contains(null, DC.title, n));
            TestLARQ.assertFalse((boolean)model.contains(null, RDFS.label, n));
        }
    }

    public void test_index_subject_1() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQ.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderSubject());
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        TestLARQ.assertEquals((int)3, (int)this.count((Iterator)nIter));
    }

    public void test_index_subject_2() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQ.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderSubject(DC.title));
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        TestLARQ.assertEquals((int)2, (int)this.count((Iterator)nIter));
    }

    public void test_index_subject_3() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQ.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderSubject());
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        while (nIter.hasNext()) {
            RDFNode n = nIter.nextNode();
            TestLARQ.assertTrue((boolean)(n instanceof Resource));
            TestLARQ.assertTrue((boolean)model.contains((Resource)n, null, (RDFNode)null));
            boolean b = model.contains((Resource)n, DC.title, (RDFNode)null) || model.contains((Resource)n, RDFS.label, (RDFNode)null);
            TestLARQ.assertTrue((String)"subject with DC.title or RDFS.label", (boolean)b);
        }
    }

    public void test_index_subject_4() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQ.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderSubject(DC.title));
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        while (nIter.hasNext()) {
            RDFNode n = nIter.nextNode();
            TestLARQ.assertTrue((boolean)(n instanceof Resource));
            TestLARQ.assertTrue((boolean)model.contains((Resource)n, null, (RDFNode)null));
            TestLARQ.assertTrue((boolean)model.contains((Resource)n, DC.title, (RDFNode)null));
        }
    }

    public void test_negative_1() {
        IndexLARQ index = TestLARQ.createIndex(datafile, (IndexBuilderModel)new IndexBuilderString());
        TestLARQ.assertFalse((boolean)index.hasMatch("+iceberg"));
    }

    public void test_negative_2() {
        IndexLARQ index = TestLARQ.createIndex(datafile, (IndexBuilderModel)new IndexBuilderString(DC.title));
        TestLARQ.assertFalse((boolean)index.hasMatch("+iceberg"));
    }

    public void test_negative_3() {
        IndexLARQ index = TestLARQ.createIndex(datafile, (IndexBuilderModel)new IndexBuilderSubject());
        TestLARQ.assertFalse((boolean)index.hasMatch("+iceberg"));
    }

    public void test_negative_4() {
        IndexLARQ index = TestLARQ.createIndex(datafile, (IndexBuilderModel)new IndexBuilderSubject(DC.title));
        TestLARQ.assertFalse((boolean)index.hasMatch("+iceberg"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_textMatches_index_registration_1() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQ.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString());
        TestLARQ.assertFalse((boolean)ARQ.getContext().isDefined(LARQ.indexKey));
        try {
            LARQ.setDefaultIndex((IndexLARQ)index);
            TestLARQ.assertTrue((boolean)ARQ.getContext().isDefined(LARQ.indexKey));
            QueryExecution qExec = this.query(model, "{ ?lit pf:textMatch '+document' }");
            ResultSet rs = qExec.execSelect();
            TestLARQ.assertEquals((int)3, (int)this.count(rs));
            qExec.close();
            index.close();
            LARQ.removeDefaultIndex();
            TestLARQ.assertFalse((boolean)ARQ.getContext().isDefined(LARQ.indexKey));
        }
        finally {
            LARQ.removeDefaultIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_textMatches_index_registration_2() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQ.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString());
        TestLARQ.assertFalse((boolean)ARQ.getContext().isDefined(LARQ.indexKey));
        QueryExecution qExec = this.query(model, "{ ?lit pf:textMatch '+document' }");
        try {
            LARQ.setDefaultIndex((Context)qExec.getContext(), (IndexLARQ)index);
            TestLARQ.assertFalse((boolean)ARQ.getContext().isDefined(LARQ.indexKey));
            TestLARQ.assertTrue((boolean)qExec.getContext().isDefined(LARQ.indexKey));
            ResultSet rs = qExec.execSelect();
            TestLARQ.assertEquals((int)3, (int)this.count(rs));
            qExec.close();
            index.close();
            LARQ.removeDefaultIndex((Context)qExec.getContext());
            TestLARQ.assertFalse((boolean)qExec.getContext().isDefined(LARQ.indexKey));
            TestLARQ.assertFalse((boolean)ARQ.getContext().isDefined(LARQ.indexKey));
        }
        finally {
            LARQ.removeDefaultIndex();
        }
    }

    public void test_textMatches_literal_1() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQ.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString());
        LARQ.setDefaultIndex((IndexLARQ)index);
        QueryExecution qExec = this.query(model, "{ ?lit pf:textMatch '+document' }");
        ResultSet rs = qExec.execSelect();
        TestLARQ.assertEquals((int)3, (int)this.count(rs));
        qExec.close();
        index.close();
        LARQ.removeDefaultIndex();
    }

    public void test_textMatches_literal_2() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQ.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString(DC.title));
        LARQ.setDefaultIndex((IndexLARQ)index);
        QueryExecution qExec = this.query(model, "{ ?lit pf:textMatch '+document' }");
        ResultSet rs = qExec.execSelect();
        TestLARQ.assertEquals((int)2, (int)this.count(rs));
        qExec.close();
        index.close();
        LARQ.removeDefaultIndex();
    }

    public void test_textMatches_literal_3() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQ.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString());
        LARQ.setDefaultIndex((IndexLARQ)index);
        QueryExecution qExec = this.query(model, "{ ?lit pf:textMatch '+document' }");
        ResultSetRewindable rs1 = ResultSetFactory.makeRewindable((ResultSet)qExec.execSelect());
        ResultSetRewindable rs2 = ResultSetFactory.makeRewindable((ResultSet)ResultSetFactory.load((String)results1));
        TestLARQ.assertTrue((boolean)RSCompare.same((ResultSet)rs1, (ResultSet)rs2));
        qExec.close();
        index.close();
        LARQ.removeDefaultIndex();
    }

    public void test_textMatches_literal_4() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQ.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString());
        LARQ.setDefaultIndex((IndexLARQ)index);
        QueryExecution qExec = this.query(model, "{ ?lit pf:textMatch '+document' . ?lit pf:textMatch '+document'}");
        ResultSetRewindable rs1 = ResultSetFactory.makeRewindable((ResultSet)qExec.execSelect());
        ResultSetRewindable rs2 = ResultSetFactory.makeRewindable((ResultSet)ResultSetFactory.load((String)results1));
        TestLARQ.assertTrue((boolean)RSCompare.same((ResultSet)rs1, (ResultSet)rs2));
        qExec.close();
        index.close();
        LARQ.removeDefaultIndex();
    }

    public void test_textMatches_literal_5() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQ.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString());
        LARQ.setDefaultIndex((IndexLARQ)index);
        QueryExecution qExec = this.query(model, "{ ?lit pf:textMatch '+document' . ?doc ?p ?lit }");
        ResultSetRewindable rs1 = ResultSetFactory.makeRewindable((ResultSet)qExec.execSelect());
        ResultSetRewindable rs2 = ResultSetFactory.makeRewindable((ResultSet)ResultSetFactory.load((String)results2));
        TestLARQ.assertTrue((boolean)RSCompare.same((ResultSet)rs1, (ResultSet)rs2));
        qExec.close();
        index.close();
        LARQ.removeDefaultIndex();
    }

    public void test_textMatches_subject_1() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQ.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderSubject(DC.title));
        LARQ.setDefaultIndex((IndexLARQ)index);
        QueryExecution qExec = this.query(model, "{ ?subj pf:textMatch '+document' }");
        ResultSetRewindable rs1 = ResultSetFactory.makeRewindable((ResultSet)qExec.execSelect());
        ResultSetRewindable rs2 = ResultSetFactory.makeRewindable((ResultSet)ResultSetFactory.load((String)results3));
        TestLARQ.assertTrue((boolean)RSCompare.same((ResultSet)rs1, (ResultSet)rs2));
        qExec.close();
        index.close();
        LARQ.removeDefaultIndex();
    }

    private QueryExecution query(Model model, String pattern) {
        return this.query(model, pattern, null);
    }

    private QueryExecution query(Model model, String pattern, IndexLARQ index) {
        String queryString = StringUtils.join((String)"\n", (String[])new String[]{"PREFIX xsd: <http://www.w3.org/2001/XMLSchema#>", "PREFIX : <http://example/>", "PREFIX pf: <java:com.hp.hpl.jena.query.pfunction.library.>", "PREFIX  dc:    <http://purl.org/dc/elements/1.1/>", "SELECT *", pattern});
        Query query2 = QueryFactory.create((String)queryString);
        QueryExecution qExec = QueryExecutionFactory.create((Query)query2, (Model)model);
        if (index != null) {
            LARQ.setDefaultIndex((Context)qExec.getContext(), (IndexLARQ)index);
        }
        return qExec;
    }

    private int count(ResultSet rs) {
        return ResultSetFormatter.consume((ResultSet)rs);
    }

    private int count(Iterator iter) {
        int count = 0;
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        NiceIterator.close((Iterator)iter);
        return count;
    }

    private static IndexLARQ createIndex(String datafile, IndexBuilderModel indexBuilder) {
        return TestLARQ.createIndex(ModelFactory.createDefaultModel(), datafile, indexBuilder);
    }

    private static IndexLARQ createIndex(Model model, String datafile, IndexBuilderModel indexBuilder) {
        model.register((ModelChangedListener)indexBuilder);
        FileManager.get().readModel(model, datafile);
        model.unregister((ModelChangedListener)indexBuilder);
        indexBuilder.closeForWriting();
        return indexBuilder.getIndex();
    }
}

