/*
 * Decompiled with CFR 0.152.
 */
package org.sercho.masp.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sercho.masp.util.NoField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldUtility {
    private static final transient Map<Class<?>, Map<String, Accessor>> ACCESSORS = new HashMap();
    private static final String GETTER_PREFIX = "get";
    private static final String IS_GETTER_PREFIX = "is";
    private static final String SETTER_PREFIX = "set";

    private static void extractGetter(String methodName, Method method, Map<String, Method> getters, Map<String, Method> setters, Map<String, Class<?>> types) {
        if (methodName.length() <= GETTER_PREFIX.length()) {
            return;
        }
        if (method.getParameterTypes().length == 0) {
            Class<?> fieldType = types.get(methodName = FieldUtility.toLowerCaseFirst(methodName.substring(GETTER_PREFIX.length())));
            if (fieldType == null) {
                fieldType = method.getReturnType();
                if (fieldType == Void.TYPE) {
                    return;
                }
                types.put(methodName, fieldType);
                getters.put(methodName, method);
                return;
            }
            if (fieldType.equals(method.getReturnType())) {
                getters.put(methodName, method);
            } else {
                setters.remove(methodName);
            }
        }
    }

    private static void extractBooleanGetter(String methodName, Method method, Map<String, Method> getters, Map<String, Method> setters, Map<String, Class<?>> types) {
        if (methodName.length() <= IS_GETTER_PREFIX.length()) {
            return;
        }
        if (method.getParameterTypes().length == 0) {
            Class<?> fieldType = types.get(methodName = FieldUtility.toLowerCaseFirst(methodName.substring(IS_GETTER_PREFIX.length())));
            if (fieldType == null) {
                fieldType = method.getReturnType();
                if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
                    types.put(methodName, fieldType);
                    getters.put(methodName, method);
                }
                return;
            }
            if (fieldType != Boolean.TYPE && fieldType != Boolean.class) {
                return;
            }
            if (fieldType.equals(method.getReturnType())) {
                getters.put(methodName, method);
            } else {
                setters.remove(methodName);
            }
        }
    }

    private static void extractSetter(String methodName, Method method, Map<String, Method> getters, Map<String, Method> setters, Map<String, Class<?>> types) {
        if (methodName.length() <= SETTER_PREFIX.length()) {
            return;
        }
        if (method.getReturnType() != Void.TYPE) {
            return;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 1) {
            Class<?> fieldType = types.get(methodName = FieldUtility.toLowerCaseFirst(methodName.substring(SETTER_PREFIX.length())));
            if (fieldType == null) {
                fieldType = parameterTypes[0];
                if (fieldType == Void.TYPE) {
                    return;
                }
                types.put(methodName, fieldType);
                setters.put(methodName, method);
                return;
            }
            if (fieldType.equals(parameterTypes[0])) {
                setters.put(methodName, method);
            } else {
                getters.remove(methodName);
            }
        }
    }

    private static List<Field> getAllFields(Class<?> c) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Field field : c.getFields()) {
            if (Modifier.isStatic(field.getModifiers()) || field.getAnnotation(NoField.class) != null) continue;
            fields.add(field);
        }
        return fields;
    }

    public static String toString(Object o) {
        if (o == null) {
            return "null";
        }
        StringBuffer buffer = new StringBuffer(100);
        Class<?> c = o.getClass();
        buffer.append(c.getSimpleName());
        Map<String, Object> fields = FieldUtility.getNonNullFields(o);
        buffer.append('[');
        if (fields.isEmpty()) {
            buffer.append(']');
            return buffer.toString();
        }
        Iterator<Map.Entry<String, Object>> i = fields.entrySet().iterator();
        while (true) {
            Map.Entry<String, Object> entry = i.next();
            buffer.append(entry.getKey());
            buffer.append('=');
            buffer.append(entry.getValue());
            if (!i.hasNext()) {
                buffer.append(']');
                return buffer.toString();
            }
            buffer.append(", ");
        }
    }

    public static void setFieldValue(Object object, String fieldName, Object newValue) {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName is null");
        }
        FieldUtility.set(object, fieldName, newValue);
    }

    private static void set(Object object, String fieldName, Object newValue) {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName is null");
        }
        Accessor accessor = FieldUtility.getClassAccessors(object.getClass()).get(fieldName);
        if (accessor == null) {
            throw new IllegalArgumentException("No field \"" + fieldName + "\" exists is class " + object.getClass().getName());
        }
        accessor.set(object, newValue);
    }

    public static Object getFieldValue(Object object, String fieldName) {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName is null");
        }
        return FieldUtility.get(object, fieldName);
    }

    private static Object get(Object object, String fieldName) {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName is null");
        }
        Accessor accessor = FieldUtility.getClassAccessors(object.getClass()).get(fieldName);
        if (accessor == null) {
            throw new IllegalArgumentException("No field \"" + fieldName + "\" exists is class " + object.getClass().getName());
        }
        return accessor.get(object);
    }

    public static Class<?> getFieldType(Object object, String fieldName) {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName is null");
        }
        Accessor accessor = FieldUtility.getClassAccessors(object.getClass()).get(fieldName);
        if (accessor == null) {
            throw new IllegalArgumentException("No field \"" + fieldName + "\" exists is class " + object.getClass().getName());
        }
        return accessor.getType();
    }

    public static Set<String> getFieldNames(Class<?> type) {
        return FieldUtility.getClassAccessors(type).keySet();
    }

    public static Map<String, Object> getNonNullFields(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("o is null");
        }
        Map<String, Object> fields = FieldUtility.getFields(o);
        Iterator<Object> i = fields.values().iterator();
        while (i.hasNext()) {
            if (i.next() != null) continue;
            i.remove();
        }
        return fields;
    }

    public static Map<String, Object> getFields(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("o is null");
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<String, Accessor> entry : FieldUtility.getClassAccessors(o.getClass()).entrySet()) {
            values.put(entry.getKey(), entry.getValue().get(o));
        }
        return values;
    }

    private static Map<String, Accessor> getClassAccessors(Class<?> type) {
        Map<String, Accessor> accessors = ACCESSORS.get(type);
        return accessors == null ? FieldUtility.initClassAccessors(type) : accessors;
    }

    private static synchronized Map<String, Accessor> initClassAccessors(Class<?> type) {
        Map<String, Accessor> accessors = ACCESSORS.get(type);
        if (accessors == null) {
            Method[] methods;
            accessors = new HashMap<String, Accessor>();
            for (Field field : FieldUtility.getAllFields(type)) {
                accessors.put(FieldUtility.toLowerCaseFirst(field.getName()), new FieldAccessor(field));
            }
            HashMap<String, Method> getters = new HashMap<String, Method>();
            HashMap<String, Method> setters = new HashMap<String, Method>();
            HashMap types = new HashMap();
            for (Method method : methods = type.getMethods()) {
                if (Modifier.isStatic(method.getModifiers()) || method.getAnnotation(NoField.class) != null) continue;
                String methodName = method.getName();
                if (methodName.startsWith(GETTER_PREFIX)) {
                    FieldUtility.extractGetter(methodName, method, getters, setters, types);
                    continue;
                }
                if (methodName.startsWith(IS_GETTER_PREFIX)) {
                    FieldUtility.extractBooleanGetter(methodName, method, getters, setters, types);
                    continue;
                }
                if (!methodName.startsWith(SETTER_PREFIX)) continue;
                FieldUtility.extractSetter(methodName, method, getters, setters, types);
            }
            Set gettersKeySet = getters.keySet();
            Set settersKeySet = setters.keySet();
            gettersKeySet.retainAll(settersKeySet);
            settersKeySet.retainAll(gettersKeySet);
            for (String fieldName : gettersKeySet) {
                accessors.put(fieldName, new GetterSetterAccessor((Method)getters.get(fieldName), (Method)setters.get(fieldName)));
            }
            accessors = Collections.unmodifiableMap(accessors);
            ACCESSORS.put(type, accessors);
        }
        return accessors;
    }

    private static String toLowerCaseFirst(String s) {
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static <T> boolean equals(T o1, T o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        Map<String, Object> fields1 = FieldUtility.getNonNullFields(o1);
        Map<String, Object> fields2 = FieldUtility.getNonNullFields(o2);
        if (fields1.isEmpty() && Comparable.class.isInstance(o1)) {
            try {
                return ((Comparable)Comparable.class.cast(o1)).compareTo(o2) == 0;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return FieldUtility.compare(fields1, fields2);
    }

    private static boolean compare(Map<?, ?> map1, Map<?, ?> map2) {
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<?, ?> entry : map1.entrySet()) {
            if (FieldUtility.equals(entry.getValue(), map2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private FieldUtility() {
    }

    private static final class GetterSetterAccessor
    extends Accessor {
        private final Method getter;
        private final Method setter;

        GetterSetterAccessor(Method g, Method s) {
            super(g.getReturnType());
            this.getter = g;
            this.setter = s;
        }

        Object get(Object o) {
            try {
                return this.getter.invoke(o, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Failed to invoke getter", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Failed to access getter", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Getter thrown an exception", e.getCause());
            }
        }

        void set(Object o, Object newValue) {
            try {
                this.setter.invoke(o, newValue);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Failed to invoke setter", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Failed to access setter", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Setter thrown an exception", e.getCause());
            }
        }
    }

    private static final class FieldAccessor
    extends Accessor {
        private final Field field;

        FieldAccessor(Field f) {
            super(f.getType());
            this.field = f;
        }

        Object get(Object o) {
            try {
                return this.field.get(o);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Failed to get value of field", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Failed to access value of field", e);
            }
        }

        void set(Object o, Object newValue) {
            try {
                this.field.set(o, newValue);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Failed to set value of field", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Failed to access value of field", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Accessor {
        private final Class<?> type;

        Accessor(Class<?> fieldType) {
            this.type = fieldType;
        }

        abstract Object get(Object var1);

        abstract void set(Object var1, Object var2);

        Class<?> getType() {
            return this.type;
        }
    }
}

