/*
 * Decompiled with CFR 0.152.
 */
package arq.cmd;

import arq.cmd.ResultsFormat;
import com.hp.hpl.jena.query.DataFormat;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.engineHTTP.HttpQuery;
import com.hp.hpl.jena.query.engineHTTP.QueryExceptionHTTP;
import com.hp.hpl.jena.query.parser.Parser;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.vocabulary.ResultSetVocab;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QCmd
implements Serializable {
    static final long serialVersionUID = 7761L;
    private static Log log = LogFactory.getLog((Class)QCmd.class);
    private String queryString = null;
    private String queryFilename = null;
    private Syntax inSyntax = null;
    private Syntax defaultSyntax = null;
    private Query query = null;
    private String baseURI = null;
    private Dataset dataset = null;
    private String service = null;
    private boolean forcePost = false;
    private FileManager fileManager = null;
    private List graphURLs = null;
    private List namedGraphURLs = null;
    private DataFormat dataSyntax = null;
    private Syntax outSyntax = null;
    private boolean lineNumbers = false;
    private ResultsFormat outputFormat = null;
    private int messageLevel = 0;

    public void query() {
        this.queryFixOutputFormat();
        if (this.service != null) {
            this.queryRemote();
        } else {
            this.queryLocal();
        }
    }

    public void printQuery() {
        IndentedWriter indentedWriter = new IndentedWriter(System.out, this.lineNumbers);
        this.query.serialize(indentedWriter, this.outSyntax);
        indentedWriter.flush();
    }

    public void checkParse() {
        if (!Parser.canParse(this.outSyntax)) {
            return;
        }
        IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
        this.query.serialize(indentedLineBuffer, this.outSyntax);
        String string = indentedLineBuffer.toString();
        try {
            Query query2 = QueryFactory.create(string, this.outSyntax);
            if (query2 == null) {
                return;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return;
        }
        catch (QueryException queryException) {
            System.out.println();
            System.out.println("**** Check failed : could not parse output query:: ");
            System.out.println("**** " + queryException.getMessage());
        }
    }

    public void queryLocal() {
        this.queryFixDataset();
        this.dumpData();
        this.parseQuery();
        if (this.query == null) {
            return;
        }
        this.queryExecLocal();
    }

    void queryFixDataset() {
        try {
            if (this.graphURLs != null || this.namedGraphURLs != null) {
                this.dataset = DatasetFactory.create(this.graphURLs, this.namedGraphURLs, this.fileManager, null);
            }
        }
        catch (JenaException jenaException) {
            System.err.println("Error loading URL: " + jenaException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println("Error creating dataset: " + exception);
            exception.printStackTrace(System.err);
            System.exit(1);
        }
    }

    void queryFixOutputFormat() {
        if (this.outputFormat == null) {
            this.outputFormat = ResultsFormat.FMT_TEXT;
        }
    }

    public void parseQuery() {
        if (this.query != null) {
            return;
        }
        if (this.queryFilename != null && this.queryString != null) {
            System.err.println("Both query string and query file name given");
            return;
        }
        if (this.queryFilename == null && this.queryString == null) {
            System.err.println("No query string and no query file name given");
            return;
        }
        try {
            if (this.queryFilename != null) {
                this.query = QueryFactory.read(this.queryFilename, this.baseURI, this.inSyntax);
            }
            if (this.queryString != null) {
                if (this.inSyntax == null) {
                    this.inSyntax = Syntax.syntaxSPARQL;
                }
                this.query = QueryFactory.create(this.queryString, this.baseURI, this.inSyntax);
            }
        }
        catch (ARQInternalErrorException aRQInternalErrorException) {
            System.err.println(aRQInternalErrorException.getMessage());
            if (aRQInternalErrorException.getCause() != null) {
                System.err.println("Cause:");
                aRQInternalErrorException.getCause().printStackTrace(System.err);
                System.err.println();
            }
            aRQInternalErrorException.printStackTrace(System.err);
            return;
        }
        catch (QueryException queryException) {
            System.err.println(queryException.getMessage());
            return;
        }
        catch (JenaException jenaException) {
            System.err.println(jenaException.getMessage());
            return;
        }
        catch (Exception exception) {
            System.out.flush();
            exception.printStackTrace(System.err);
            return;
        }
    }

    void queryExecLocal() {
        try {
            QueryExecution queryExecution = QueryExecutionFactory.create(this.query, this.dataset);
            if (this.dataset == null && !this.query.hasDatasetDescription()) {
                System.err.println("Dataset not specified in query nor provided on command line.");
                return;
            }
            if (this.fileManager != null) {
                queryExecution.setFileManager(this.fileManager);
            }
            this.doQuery(this.query, queryExecution, this.outputFormat);
            queryExecution.close();
        }
        catch (ARQInternalErrorException aRQInternalErrorException) {
            System.err.println(aRQInternalErrorException.getMessage());
            if (aRQInternalErrorException.getCause() != null) {
                System.err.println("Cause:");
                aRQInternalErrorException.getCause().printStackTrace(System.err);
                System.err.println();
            }
            aRQInternalErrorException.printStackTrace(System.err);
        }
        catch (QueryException queryException) {
            System.err.println("Query Exeception: " + (Object)((Object)queryException));
            System.exit(9);
        }
        catch (Exception exception) {
            System.out.flush();
            exception.printStackTrace(System.err);
        }
    }

    private void queryRemote() {
        this.parseQuery();
        if (this.query == null) {
            return;
        }
        try {
            QueryExecution queryExecution = QueryExecutionFactory.create(this.service, this.query, this.getGraphURLs(), this.getNamedGraphURLs());
            if (this.messageLevel > 0) {
                System.out.println(queryExecution.toString());
            }
            if (this.getForcePost()) {
                HttpQuery.urlLimit = 0;
            }
            this.doQuery(this.query, queryExecution, this.outputFormat);
        }
        catch (QueryExceptionHTTP queryExceptionHTTP) {
            System.err.println("HTTP Exeception: " + queryExceptionHTTP.getMessage());
            System.exit(9);
        }
        catch (Exception exception) {
            System.out.flush();
            exception.printStackTrace(System.err);
        }
    }

    public void doQuery(Query query2, QueryExecution queryExecution, ResultsFormat resultsFormat) {
        if (query2.isSelectType()) {
            this.doSelectQuery(query2, queryExecution, resultsFormat);
        }
        if (query2.isDescribeType()) {
            this.doDescribeQuery(query2, queryExecution, resultsFormat);
        }
        if (query2.isConstructType()) {
            this.doConstructQuery(query2, queryExecution, resultsFormat);
        }
        if (query2.isAskType()) {
            this.doAskQuery(query2, queryExecution, resultsFormat);
        }
        queryExecution.close();
    }

    void doSelectQuery(Query query2, QueryExecution queryExecution, ResultsFormat resultsFormat) {
        Object object;
        ResultSet resultSet = queryExecution.execSelect();
        resultSet = ResultSetFactory.makeRewindable(resultSet);
        boolean bl = false;
        if (resultsFormat.equals(ResultsFormat.FMT_NONE) || resultsFormat.equals(ResultsFormat.FMT_COUNT)) {
            object = new ResultSetFormatter(resultSet, query2.getPrefixMapping());
            int n = ((ResultSetFormatter)object).consume();
            if (resultsFormat.equals(ResultsFormat.FMT_COUNT)) {
                System.out.println("Count = " + n);
            }
            bl = true;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RS_RDF) || resultsFormat.equals(ResultsFormat.FMT_RDF_N3)) {
            object = new ResultSetFormatter(resultSet, query2.getPrefixMapping());
            Model model = ((ResultSetFormatter)object).toModel();
            RDFWriter rDFWriter = model.getWriter("TURTLE");
            model.setNsPrefix("rs", ResultSetVocab.getURI());
            rDFWriter.write(model, (OutputStream)System.out, null);
            bl = true;
        }
        object = FileUtils.asPrintWriterUTF8((OutputStream)System.out);
        if (resultsFormat.equals(ResultsFormat.FMT_RS_XML)) {
            ResultSetFormatter.outputAsXML(System.out, resultSet, query2);
            bl = true;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RS_TEXT)) {
            ResultSetFormatter.out(System.out, resultSet, query2);
            bl = true;
        }
        ResultSetFormatter resultSetFormatter = new ResultSetFormatter(resultSet, query2.getPrefixMapping());
        if (resultsFormat.equals(ResultsFormat.FMT_TEXT)) {
            resultSetFormatter.printAll((PrintWriter)object);
            bl = true;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_TUPLES)) {
            resultSetFormatter.dump((PrintWriter)object, true);
            bl = true;
        }
        if (!bl) {
            log.warn((Object)("Unknown format request: " + resultsFormat));
        }
        if (object != null) {
            ((PrintWriter)object).flush();
        }
    }

    void doDescribeQuery(Query query2, QueryExecution queryExecution, ResultsFormat resultsFormat) {
        Model model = queryExecution.execDescribe();
        this.writeModel(query2, model, resultsFormat);
    }

    void doConstructQuery(Query query2, QueryExecution queryExecution, ResultsFormat resultsFormat) {
        Model model = queryExecution.execConstruct();
        this.writeModel(query2, model, resultsFormat);
    }

    void writeModel(Query query2, Model model, ResultsFormat resultsFormat) {
        if (resultsFormat.equals(ResultsFormat.FMT_NONE)) {
            return;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_TEXT)) {
            String string = "";
            if (query2.isDescribeType()) {
                string = "DESCRIBE";
            }
            if (query2.isConstructType()) {
                string = "CONSTRUCT";
            }
            System.out.println("# ======== " + string + " results ");
            model.write((OutputStream)System.out, "N3", null);
            System.out.println("# ======== ");
            return;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RDF_XML)) {
            model.write((OutputStream)System.out, "RDF/XML-ABBREV", null);
            return;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RDF_N3)) {
            model.write((OutputStream)System.out, "N3", null);
            return;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RDF_NT)) {
            model.write((OutputStream)System.out, "N_TRIPLES", null);
            return;
        }
        System.err.println("Unknown format: " + resultsFormat.getSymbol());
    }

    void doAskQuery(Query query2, QueryExecution queryExecution, ResultsFormat resultsFormat) {
        boolean bl = queryExecution.execAsk();
        if (resultsFormat.equals(ResultsFormat.FMT_RS_XML)) {
            ResultSetFormatter.outputAsXML(System.out, bl);
            return;
        }
        if (!resultsFormat.equals(ResultsFormat.FMT_NONE)) {
            System.out.println("Ask => " + (bl ? "Yes" : "No"));
            return;
        }
    }

    void dumpData() {
        boolean bl = false;
        if (bl) {
            if (this.dataset == null) {
                System.out.println("Dataset is null");
            } else {
                System.out.println("Dataset: " + this.dataset);
            }
        }
    }

    public String getServiceURL() {
        return this.service;
    }

    public void setServiceURL(String string) {
        this.service = string;
    }

    public boolean getForcePost() {
        return this.forcePost;
    }

    public void setForcePost(boolean bl) {
        this.forcePost = bl;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public DataFormat getDataSyntax() {
        return this.dataSyntax;
    }

    public void setDataSyntax(DataFormat dataFormat) {
        this.dataSyntax = dataFormat;
    }

    public Syntax getDefaultSyntax() {
        return this.defaultSyntax;
    }

    public void setDefaultSyntax(Syntax syntax) {
        this.defaultSyntax = syntax;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public List getGraphURLs() {
        return this.graphURLs;
    }

    public void setGraphURLs(List list) {
        this.graphURLs = list;
    }

    public Syntax getInSyntax() {
        return this.inSyntax;
    }

    public void setInSyntax(Syntax syntax) {
        this.inSyntax = syntax;
    }

    public boolean isLineNumbers() {
        return this.lineNumbers;
    }

    public void setLineNumbers(boolean bl) {
        this.lineNumbers = bl;
    }

    public int getMessageLevel() {
        return this.messageLevel;
    }

    public void setMessageLevel(int n) {
        this.messageLevel = n;
    }

    public List getNamedGraphURLs() {
        return this.namedGraphURLs;
    }

    public void setNamedGraphURLs(List list) {
        this.namedGraphURLs = list;
    }

    public ResultsFormat getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(ResultsFormat resultsFormat) {
        this.outputFormat = resultsFormat;
    }

    public Syntax getOutSyntax() {
        return this.outSyntax;
    }

    public void setOutSyntax(Syntax syntax) {
        this.outSyntax = syntax;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query2) {
        this.query = query2;
    }

    public String getQueryFilename() {
        return this.queryFilename;
    }

    public void setQueryFilename(String string) {
        this.queryFilename = string;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }
}

