/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdUtils;
import arq.cmd.QCmd;
import arq.cmdline.ArgDecl;
import arq.cmdline.CommandLine;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.engine1.Plan;
import com.hp.hpl.jena.query.engine1.PlanFormatter;
import com.hp.hpl.jena.query.engine1.QueryEngineAccess;
import com.hp.hpl.jena.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;

public class qparse {
    static String usage;

    public static void main(String[] stringArray) {
        Object object;
        CommandLine commandLine = new CommandLine();
        ArgDecl argDecl = new ArgDecl(false, "v", "verbose");
        ArgDecl argDecl2 = new ArgDecl(false, "h", "help");
        ArgDecl argDecl3 = new ArgDecl(false, "debug");
        ArgDecl argDecl4 = new ArgDecl(true, "in");
        ArgDecl argDecl5 = new ArgDecl(true, "out");
        ArgDecl argDecl6 = new ArgDecl(true, "file", "query");
        ArgDecl argDecl7 = new ArgDecl(false, "num");
        ArgDecl argDecl8 = new ArgDecl(false, "plain");
        ArgDecl argDecl9 = new ArgDecl(false, "n", "parse");
        ArgDecl argDecl10 = new ArgDecl(true, "planning");
        ArgDecl argDecl11 = new ArgDecl(true, "show");
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        commandLine.add(argDecl);
        commandLine.add(argDecl3);
        commandLine.add(argDecl2);
        commandLine.add(argDecl8);
        commandLine.add(argDecl7);
        commandLine.add(argDecl9);
        commandLine.add(argDecl4);
        commandLine.add(argDecl5);
        commandLine.add(argDecl6);
        commandLine.add(argDecl10);
        commandLine.add(argDecl11);
        QCmd qCmd = new QCmd();
        try {
            commandLine.process(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            System.exit(9);
        }
        if (commandLine.contains(argDecl2)) {
            qparse.usage();
            System.exit(0);
        }
        if (commandLine.contains(argDecl10)) {
            object = commandLine.getValue(argDecl10);
            if (((String)object).equalsIgnoreCase("on") || ((String)object).equalsIgnoreCase("yes")) {
                ARQ.enableAnyOrderOptionals = true;
            } else if (((String)object).equalsIgnoreCase("off") || ((String)object).equalsIgnoreCase("no")) {
                ARQ.enableAnyOrderOptionals = false;
            } else {
                System.err.println("Unrecognized planning control: " + (String)object);
                System.exit(3);
            }
        }
        if (commandLine.contains(argDecl11)) {
            object = commandLine.getValues(argDecl11);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string.equalsIgnoreCase("plan")) {
                    bl3 = true;
                }
                if (!string.equalsIgnoreCase("query")) continue;
                bl2 = true;
            }
        }
        if (commandLine.contains(argDecl4)) {
            object = Syntax.lookup(commandLine.getValue(argDecl4));
            if (object == null) {
                qparse.msg("Unknown query syntax for input: " + commandLine.getArg(argDecl4).getValue());
                qparse.writeSyntaxes("Known syntaxes (not all implemented for both input and output)", System.err);
                System.exit(9);
            }
            qCmd.setInSyntax((Syntax)object);
        }
        if (commandLine.contains(argDecl5)) {
            object = Syntax.lookup(commandLine.getValue(argDecl5));
            if (object == null) {
                qparse.msg("Unknown query syntax for output: " + commandLine.getArg(argDecl5).getValue());
                qparse.writeSyntaxes("Known syntaxes", System.err);
                System.exit(9);
            }
            qCmd.setOutSyntax((Syntax)object);
        }
        if (qCmd.getOutSyntax() == null) {
            qCmd.setOutSyntax(Syntax.syntaxSPARQL);
        }
        qCmd.setLineNumbers(true);
        if (commandLine.contains(argDecl7)) {
            qCmd.setLineNumbers(true);
        }
        if (commandLine.contains(argDecl8)) {
            qCmd.setLineNumbers(false);
        }
        if (commandLine.contains(argDecl9)) {
            bl = false;
        }
        if (commandLine.contains(argDecl6)) {
            object = commandLine.getValues(argDecl6).iterator();
            while (object.hasNext()) {
                qCmd.setQueryFilename((String)object.next());
                qparse.process(qCmd, bl, bl2, bl3);
            }
            return;
        }
        if (commandLine.items().size() == 0) {
            commandLine.items().add("-");
        }
        if (commandLine.items().size() == 0) {
            System.err.println("Nothing to do");
            System.exit(9);
        }
        if (commandLine.items().size() > 1) {
            System.err.println("Only one string at a time");
            System.exit(9);
        }
        qCmd.setQueryFilename(null);
        qCmd.setQueryString((String)commandLine.items().get(0));
        if (qCmd.getQueryString().equals("-")) {
            try {
                qCmd.setQueryFilename(null);
                qCmd.setQueryString(FileUtils.readWholeFileAsUTF8((InputStream)System.in));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        qparse.process(qCmd, bl, bl2, bl3);
    }

    static void process(QCmd qCmd, boolean bl, boolean bl2, boolean bl3) {
        qCmd.parseQuery();
        if (qCmd.getQuery() == null) {
            return;
        }
        if (bl2) {
            qCmd.getQuery().serialize(System.out, Syntax.syntaxAbstract);
            System.out.println();
        }
        if (bl3) {
            QueryEngineAccess queryEngineAccess = new QueryEngineAccess(qCmd.getQuery());
            Plan plan = new Plan();
            queryEngineAccess.forcePlanning(plan);
            PlanFormatter.out((OutputStream)System.out, qCmd.getQuery(), plan.getRoot());
            System.out.println();
        }
        if (bl) {
            qCmd.printQuery();
        }
        qCmd.checkParse();
    }

    static void writeSyntaxes(String string, PrintStream printStream) {
        if (string != null) {
            printStream.println(string);
        }
        Iterator iterator = Syntax.querySyntaxNames.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Syntax syntax = Syntax.lookup(string2);
            string2 = qparse.padOut(string2, 10);
            printStream.println("  " + string2 + "  " + syntax);
        }
    }

    static void msg(String string) {
        System.err.println(string);
    }

    static String padOut(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = string.length(); i <= n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    static void usage() {
        qparse.msg(usage);
    }

    static void usage(PrintStream printStream) {
        printStream.println(usage);
    }

    static {
        CmdUtils.setLog4j();
        usage = qparse.class.getName() + " [--in syntax] [--out syntax] [\"query\" | --query <file>\n" + "  where syntax is one of ARQ, SPARQL, RDQL\n" + "  and the query comes from stdin or the command line";
    }
}

