/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdUtils;
import arq.cmd.QCmd;
import arq.cmd.ResultsFormat;
import arq.cmdline.ArgDecl;
import arq.cmdline.CommandLine;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.DataFormat;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.engine1.Plan;
import com.hp.hpl.jena.query.engine1.PlanFormatter;
import com.hp.hpl.jena.query.engine1.QueryEngineAccess;
import com.hp.hpl.jena.query.util.RelURI;
import com.hp.hpl.jena.query.util.TranslationTable;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.LocationMapper;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class query {
    static Syntax defaultSyntax;
    protected static Log log;
    static TranslationTable resultFormats;

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        if (stringArray.length == 0) {
            query.usage();
            System.exit(0);
        }
        CommandLine commandLine = new CommandLine();
        ArgDecl argDecl = new ArgDecl(false, "h", "help");
        commandLine.add(argDecl);
        ArgDecl argDecl2 = new ArgDecl(false, "v", "verbose");
        commandLine.add(argDecl2);
        ArgDecl argDecl3 = new ArgDecl(false, "q", "quiet");
        commandLine.add(argDecl3);
        ArgDecl argDecl4 = new ArgDecl(false, "n", "noExec", "noexec");
        commandLine.add(argDecl4);
        ArgDecl argDecl5 = new ArgDecl(true, "graph", "data");
        commandLine.add(argDecl5);
        ArgDecl argDecl6 = new ArgDecl(true, "named", "namedgraph", "namedGraph");
        commandLine.add(argDecl6);
        ArgDecl argDecl7 = new ArgDecl(true, "service");
        commandLine.add(argDecl7);
        ArgDecl argDecl8 = new ArgDecl(false, "post", "POST");
        commandLine.add(argDecl8);
        ArgDecl argDecl9 = new ArgDecl(true, "query", "file");
        commandLine.add(argDecl9);
        ArgDecl argDecl10 = new ArgDecl(true, "syntax", "syn", "in");
        commandLine.add(argDecl10);
        ArgDecl argDecl11 = new ArgDecl(true, "fmt", "format");
        commandLine.add(argDecl11);
        ArgDecl argDecl12 = new ArgDecl(true, "results", "rfmt");
        commandLine.add(argDecl12);
        ArgDecl argDecl13 = new ArgDecl(true, "planning");
        commandLine.add(argDecl13);
        ArgDecl argDecl14 = new ArgDecl(true, "show");
        commandLine.add(argDecl14);
        ArgDecl argDecl15 = new ArgDecl(true, "dir");
        commandLine.add(argDecl15);
        ArgDecl argDecl16 = new ArgDecl(true, "base");
        commandLine.add(argDecl16);
        ArgDecl argDecl17 = new ArgDecl(true, "lmap");
        commandLine.add(argDecl17);
        try {
            commandLine.process(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            query.usage(System.err);
            System.exit(2);
        }
        if (commandLine.contains(argDecl)) {
            query.usage();
            System.exit(0);
        }
        QCmd qCmd = new QCmd();
        boolean bl4 = commandLine.contains(argDecl2);
        if (bl4) {
            qCmd.setMessageLevel(qCmd.getMessageLevel() + 1);
        }
        if (bl = commandLine.contains(argDecl3)) {
            qCmd.setMessageLevel(qCmd.getMessageLevel() - 1);
        }
        boolean bl5 = true;
        if (commandLine.contains(argDecl4)) {
            bl5 = false;
        }
        if (commandLine.contains(argDecl15)) {
            object3 = commandLine.getValue(argDecl15);
            qCmd.setFileManager(new FileManager());
            qCmd.getFileManager().addLocatorFile((String)object3);
            qCmd.getFileManager().addLocatorURL();
        } else {
            qCmd.setFileManager(FileManager.get());
        }
        if (commandLine.contains(argDecl16)) {
            qCmd.setBaseURI(commandLine.getValue(argDecl16));
            RelURI.setBaseURI(qCmd.getBaseURI());
        }
        if (commandLine.contains(argDecl17)) {
            object3 = commandLine.getValue(argDecl17);
            object2 = new LocationMapper((String)object3);
            qCmd.getFileManager().setMapper((LocationMapper)object2);
        }
        if (commandLine.contains(argDecl13)) {
            object3 = commandLine.getValue(argDecl13);
            if (((String)object3).equalsIgnoreCase("on") || ((String)object3).equalsIgnoreCase("yes")) {
                ARQ.enableAnyOrderOptionals = true;
            } else if (((String)object3).equalsIgnoreCase("off") || ((String)object3).equalsIgnoreCase("no")) {
                ARQ.enableAnyOrderOptionals = false;
            } else {
                query.argError("Unrecognized planning control: " + (String)object3);
            }
        }
        if (commandLine.contains(argDecl14)) {
            object3 = commandLine.getValues(argDecl14);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (((String)object).equalsIgnoreCase("plan")) {
                    bl3 = true;
                }
                if (!((String)object).equalsIgnoreCase("query")) continue;
                bl2 = true;
            }
        }
        if (commandLine.contains(argDecl7)) {
            object3 = commandLine.getValue(argDecl7);
            qCmd.setServiceURL((String)object3);
        }
        if (commandLine.contains(argDecl8)) {
            qCmd.setForcePost(true);
        }
        qCmd.setDefaultSyntax(defaultSyntax);
        if (commandLine.contains(argDecl10)) {
            object3 = commandLine.getValue(argDecl10);
            object2 = Syntax.lookup((String)object3);
            if (object2 == null) {
                query.argError("Unrecognized syntax: " + object2);
            }
            qCmd.setInSyntax((Syntax)object2);
        }
        object3 = commandLine.getValue(argDecl9);
        if (commandLine.items().size() == 0 && object3 == null) {
            query.argError("No query string or query file");
        }
        if (commandLine.items().size() > 1) {
            query.argError("Only one query string allowed");
        }
        if (commandLine.items().size() == 1 && object3 != null) {
            query.argError("Either query string or query file - not both");
        }
        if (object3 != null) {
            qCmd.setQueryFilename((String)object3);
        } else {
            qCmd.setQueryString((String)commandLine.items().get(0));
        }
        if (commandLine.contains(argDecl5)) {
            qCmd.setGraphURLs(commandLine.getValues(argDecl5));
        }
        if (commandLine.contains(argDecl11)) {
            object2 = commandLine.getValue(argDecl11);
            qCmd.setDataSyntax(DataFormat.lookup((String)object2));
            if (qCmd.getDataSyntax() == null) {
                query.argError("Unrecognized syntax for data: " + (String)object2);
            }
        }
        if (commandLine.contains(argDecl6)) {
            qCmd.setNamedGraphURLs(commandLine.getValues(argDecl6));
        }
        if (commandLine.contains(argDecl12)) {
            object2 = commandLine.getValue(argDecl12);
            qCmd.setOutputFormat((ResultsFormat)resultFormats.lookup((String)object2));
            if (qCmd.getOutputFormat() == null) {
                query.argError("Unrecognized output format: " + (String)object2);
            }
        }
        try {
            qCmd.setLineNumbers(true);
            qCmd.parseQuery();
            if (qCmd.getQuery() == null) {
                return;
            }
            if (qCmd.getMessageLevel() > 0) {
                qCmd.printQuery();
                System.out.println();
            }
            if (bl2) {
                qCmd.getQuery().serialize(System.out, Syntax.syntaxAbstract);
                System.out.println();
            }
            if (bl3) {
                object2 = new QueryEngineAccess(qCmd.getQuery());
                object = new Plan();
                ((QueryEngineAccess)object2).forcePlanning((Plan)object);
                PlanFormatter.out((OutputStream)System.out, qCmd.getQuery(), ((Plan)object).getRoot());
                System.out.println();
            }
            if (bl5) {
                qCmd.query();
            }
        }
        catch (Exception exception) {
            System.err.println("Exception from QCmd: " + exception.getMessage());
            exception.printStackTrace(System.err);
            System.exit(9);
        }
    }

    static void usage() {
        query.usage(System.out);
    }

    static void usage(PrintStream printStream) {
        printStream.println("Usage: [--data URL] [queryString | --query file]");
        printStream.println("   --query file         Read one query from a file");
        printStream.println("   --syntax SYN         Query syntax");
        printStream.println("                            SPARQL (default), ARQ, RDQL, N3QL");
        printStream.println("                            File suffixes imply syntax:");
        printStream.println("                            .rq / SPARQL,  .arq / ARQ, .rdql / RDQL");
        printStream.println("   --graph URL          DataSource source (can also be part of query)");
        printStream.println("   --data URL           Synonym for --graph");
        printStream.println("   --namedGraph URL     DataSource source (can also be part of query)");
        printStream.println("   --named URL          Synonym for --namedGraph");
        printStream.println("                            URLs can be file: or http:");
        printStream.println("                            No schema => file:");
        printStream.println("                            Extensions used to guess the format as well");
        printStream.println("                                .rdf, .n3, .nt, .ttl");
        printStream.println("   --service URL        Execute query at given service");
        printStream.println("   --post               Force the use of HTTP POST");
        printStream.println("   --fmt FMT            Data source format: RDF/XML (default),");
        printStream.println("                            N3, N-TRIPLES, TURTLE");
        printStream.println("   --results FORM       Format of result");
        printStream.println("                          SELECT queries");
        printStream.println("                            text [default], count, tuples, none for display");
        printStream.println("                            rs, rs/graph, xml, rs/text for the result set ");
        printStream.println("                          CONSTRUCT and DESCRIBE queries");
        printStream.println("                            RDF, RDF/XML, N3, N-TRIPLES");
        printStream.println("                          ASK queries");
        printStream.println("                            xml, text");
        printStream.println("   --verbose            Verbose - more messages");
        printStream.println("   --quiet              Quiet - less messages");
        printStream.println("   -n --noExec          Don't actually execute the query");
        printStream.println("   --planning on | off  Turn off/on query planning");
        printStream.println("   --show WHAT          Print various internals details (parse trees, planning trees)");
        printStream.println("                        WHAT is currently 'plan' or 'query'");
    }

    static void argError(String string) {
        System.err.println("Argument Error: " + string);
        System.exit(3);
    }

    static {
        CmdUtils.setLog4j();
        CmdUtils.setN3Params();
        defaultSyntax = Syntax.syntaxSPARQL;
        log = LogFactory.getLog((Class)query.class);
        resultFormats = new TranslationTable(true);
        resultFormats.put("text", ResultsFormat.FMT_TEXT);
        resultFormats.put("none", ResultsFormat.FMT_NONE);
        resultFormats.put("count", ResultsFormat.FMT_COUNT);
        resultFormats.put("tuples", ResultsFormat.FMT_TUPLES);
        resultFormats.put("rs/text", ResultsFormat.FMT_RS_TEXT);
        resultFormats.put("rs/raw", ResultsFormat.FMT_RS_TEXT);
        resultFormats.put("xml", ResultsFormat.FMT_RS_XML);
        resultFormats.put("rs", ResultsFormat.FMT_RS_XML);
        resultFormats.put("rs/xml", ResultsFormat.FMT_RS_XML);
        resultFormats.put("rs/graph", ResultsFormat.FMT_RS_RDF);
        resultFormats.put("rs/rdfh", ResultsFormat.FMT_RS_RDF);
        resultFormats.put("graph", ResultsFormat.FMT_RS_RDF);
        resultFormats.put("rdf", ResultsFormat.FMT_RDF_XML);
        resultFormats.put("rdf/xml", ResultsFormat.FMT_RDF_XML);
        resultFormats.put("n3", ResultsFormat.FMT_RDF_N3);
        resultFormats.put("rs/n3", ResultsFormat.FMT_RDF_N3);
        resultFormats.put("n-triples", ResultsFormat.FMT_RDF_NT);
    }
}

