/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdUtils;
import arq.cmdline.ArgDecl;
import arq.cmdline.CommandLine;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.resultset.ResultSetFormat;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.util.FileManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class rset {
    static String usage;

    public static void main(String[] stringArray) {
        ResultSet resultSet;
        CommandLine commandLine = new CommandLine();
        ArgDecl argDecl = new ArgDecl(false, "v", "verbose");
        ArgDecl argDecl2 = new ArgDecl(false, "h", "help");
        ArgDecl argDecl3 = new ArgDecl(false, "debug");
        ArgDecl argDecl4 = new ArgDecl(true, "in");
        ArgDecl argDecl5 = new ArgDecl(true, "out");
        ArgDecl argDecl6 = new ArgDecl(true, "file");
        commandLine.add(argDecl);
        commandLine.add(argDecl3);
        commandLine.add(argDecl2);
        commandLine.add(argDecl4);
        commandLine.add(argDecl5);
        commandLine.add(argDecl6);
        try {
            commandLine.process(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            System.exit(9);
        }
        if (commandLine.contains(argDecl2)) {
            rset.usage();
            System.exit(0);
        }
        ResultSetFormat resultSetFormat = ResultSetFormat.syntaxRDF;
        if (commandLine.contains(argDecl4) && (resultSetFormat = ResultSetFormat.lookup(commandLine.getValue(argDecl4))).equals(ResultSetFormat.syntaxText)) {
            System.err.println("Can't read in the tabular text format");
            System.exit(2);
        }
        ResultSetFormat resultSetFormat2 = ResultSetFormat.syntaxXML;
        if (commandLine.contains(argDecl5)) {
            resultSetFormat2 = ResultSetFormat.lookup(commandLine.getValue(argDecl5));
        }
        String string = null;
        if (commandLine.contains(argDecl6)) {
            string = commandLine.getValue(argDecl6);
        }
        if (string == null && (resultSet = commandLine.items().iterator()).hasNext()) {
            String string2;
            string = string2 = (String)resultSet.next();
        }
        resultSet = rset.parseResultSet(string, resultSetFormat);
        rset.printResultSet(resultSet, resultSetFormat2);
    }

    static ResultSet parseResultSet(String string, ResultSetFormat resultSetFormat) {
        if (resultSetFormat.equals(ResultSetFormat.syntaxXML)) {
            InputStream inputStream = null;
            if (string == null) {
                inputStream = System.in;
            } else {
                try {
                    inputStream = new FileInputStream(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new NotFoundException("File: " + string);
                }
            }
            return ResultSetFactory.fromXML(inputStream);
        }
        if (resultSetFormat.equals(ResultSetFormat.syntaxRDF)) {
            Model model = null;
            model = string == null ? ModelFactory.createDefaultModel().read(System.in, null) : FileManager.get().loadModel(string);
            return ResultSetFactory.fromRDF(model);
        }
        rset.msg("Unknown input syntax: " + resultSetFormat);
        System.exit(9);
        return null;
    }

    private static void printResultSet(ResultSet resultSet, ResultSetFormat resultSetFormat) {
        ResultSetFormatter resultSetFormatter = new ResultSetFormatter(resultSet);
        if (resultSetFormat.equals(ResultSetFormat.syntaxXML)) {
            resultSetFormatter.outputAsXML(System.out);
            return;
        }
        if (resultSetFormat.equals(ResultSetFormat.syntaxRDF)) {
            Model model = resultSetFormatter.toModel();
            model.write((OutputStream)System.out, "N3");
            return;
        }
        if (resultSetFormat.equals(ResultSetFormat.syntaxText)) {
            resultSetFormatter.printAll(System.out);
            return;
        }
        rset.msg("Unknown output syntax: " + resultSetFormat);
        System.exit(9);
    }

    static void msg(String string) {
        System.err.println(string);
    }

    static void usage() {
        rset.msg(usage);
    }

    static void usage(PrintStream printStream) {
        printStream.println(usage);
    }

    static {
        CmdUtils.setLog4j();
        CmdUtils.setN3Params();
        usage = rset.class.getName() + " [--in syntax] [--out syntax] [--file FILE | FILE ]\n" + "  where syntax is one of XML, RDF";
    }
}

