/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.core.DataSourceGraphImpl;
import com.hp.hpl.jena.query.core.DataSourceImpl;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.util.RelURI;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.FileManager;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatasetFactory {
    private static Log log = LogFactory.getLog((Class)DatasetFactory.class);

    public static Dataset merge(List list) {
        return DatasetFactory.merge(list, null);
    }

    public static Dataset merge(List list, FileManager fileManager) {
        return DatasetFactory.create(list, null, fileManager, null);
    }

    public static DataSource create() {
        return new DataSourceImpl();
    }

    public static Dataset create(List list) {
        return DatasetFactory.create(list, null, null, null);
    }

    public static Dataset create(List list, FileManager fileManager) {
        return DatasetFactory.create(list, null, fileManager, null);
    }

    public static Dataset createNamed(List list, FileManager fileManager) {
        return DatasetFactory.create(null, list, fileManager, null);
    }

    public static Dataset create(List list, List list2) {
        return DatasetFactory.create(list, list2, null, null);
    }

    public static Dataset create(List list, List list2, FileManager fileManager, String string) {
        DatasetGraph datasetGraph = DatasetFactory.createDatasetGraph(list, list2, fileManager, string);
        return new DataSourceImpl(datasetGraph);
    }

    public static DatasetGraph createDatasetGraph(List list, List list2, FileManager fileManager, String string) {
        String string2;
        Object object;
        Object object2;
        DataSourceGraphImpl dataSourceGraphImpl = new DataSourceGraphImpl();
        if (fileManager == null) {
            fileManager = FileManager.get();
        }
        if (list != null) {
            object2 = ModelFactory.createDefaultModel();
            object = list.iterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                log.debug((Object)("Load(unnamed): " + string2));
                fileManager.readModel((Model)object2, string2, string, null);
            }
            dataSourceGraphImpl.setDefaultGraph(object2.getGraph());
            dataSourceGraphImpl.setActiveGraph(dataSourceGraphImpl.getDefaultGraph());
        } else {
            dataSourceGraphImpl.setDefaultGraph(ModelFactory.createDefaultModel().getGraph());
            dataSourceGraphImpl.setActiveGraph(dataSourceGraphImpl.getDefaultGraph());
        }
        if (list2 != null) {
            object2 = list2.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                string2 = null;
                string2 = string != null ? RelURI.resolve((String)object, string) : RelURI.resolve((String)object);
                log.debug((Object)("Load(named): " + (String)object + " as " + string2));
                Model model = fileManager.loadModel((String)object, string, null);
                dataSourceGraphImpl.addNamedGraph(string2, model.getGraph());
            }
        }
        return dataSourceGraphImpl;
    }

    public static Dataset make(Dataset dataset) {
        DataSourceImpl dataSourceImpl = new DataSourceImpl(dataset);
        return dataSourceImpl;
    }

    public static Dataset make(Dataset dataset, Model model) {
        DataSourceImpl dataSourceImpl = new DataSourceImpl(dataset);
        dataSourceImpl.setDefaultModel(model);
        return dataSourceImpl;
    }
}

