/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.DescribeHandler;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryVisitor;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.Template;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.function.FunctionRegistry;
import com.hp.hpl.jena.query.serializer.Serializer;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.util.RelURI;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Query {
    static Log log = LogFactory.getLog((Class)Query.class);
    public static final int QueryTypeUnknown = -123;
    public static final int QueryTypeSelect = 111;
    public static final int QueryTypeConstruct = 222;
    public static final int QueryTypeDescribe = 333;
    public static final int QueryTypeAsk = 444;
    int queryType = -123;
    List graphURIs = new ArrayList();
    List namedGraphURIs = new ArrayList();
    ElementBlock queryBlock = null;
    Syntax syntax = Syntax.syntaxSPARQL;
    public static long NOLIMIT = Long.MIN_VALUE;
    long resultLimit = NOLIMIT;
    long resultOffset = NOLIMIT;
    List orderBy = null;
    public static int ASCENDING = 1;
    public static int DESCENDING = -1;
    boolean strictQuery = true;
    protected boolean queryResultStar = false;
    protected List resultVars = new ArrayList();
    protected boolean distinct = false;
    protected Template constructTemplate = null;
    protected List resultNodes = new ArrayList();
    protected DescribeHandler defaultDescribeHandler = null;
    protected boolean seenBaseURI = false;
    protected String baseURI = null;
    protected FunctionRegistry registry = FunctionRegistry.global();
    protected PrefixMapping prefixMap = new PrefixMappingImpl();

    public Query() {
        this.syntax = Syntax.syntaxSPARQL;
    }

    public void setQueryType(int n) {
        this.queryType = n;
    }

    public int getQueryType() {
        return this.queryType;
    }

    public void setStrict(boolean bl) {
        this.strictQuery = bl;
        if (this.strictQuery) {
            this.initStrict();
        } else {
            this.initLax();
        }
    }

    public boolean isStrict() {
        return this.strictQuery;
    }

    private void initStrict() {
    }

    private void initLax() {
    }

    public void setDistinct(boolean bl) {
        this.distinct = bl;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public void setSyntax(Syntax syntax) {
        this.syntax = syntax;
    }

    public long getLimit() {
        return this.resultLimit;
    }

    public void setLimit(long l) {
        this.resultLimit = l;
    }

    public boolean hasLimit() {
        return this.resultLimit != NOLIMIT;
    }

    public long getOffset() {
        return this.resultOffset;
    }

    public void setOffset(long l) {
        this.resultOffset = l;
    }

    public boolean hasOffset() {
        return this.resultOffset != NOLIMIT;
    }

    public boolean hasOrderBy() {
        return this.orderBy != null && this.orderBy.size() > 0;
    }

    public void addOrderBy(SortCondition sortCondition) {
        if (this.orderBy == null) {
            this.orderBy = new ArrayList();
        }
        this.orderBy.add(sortCondition);
    }

    public void addOrderBy(Expr expr, int n) {
        SortCondition sortCondition = new SortCondition(expr, n);
        this.addOrderBy(sortCondition);
    }

    public void addOrderBy(Node node, int n) {
        if (!node.isVariable()) {
            throw new QueryException("Not a variable: " + node);
        }
        SortCondition sortCondition = new SortCondition(node, n);
        this.addOrderBy(sortCondition);
    }

    public void addOrderBy(String string, int n) {
        SortCondition sortCondition = new SortCondition(string, n);
        this.addOrderBy(sortCondition);
    }

    public List getOrderBy() {
        return this.orderBy;
    }

    public boolean isSelectType() {
        return this.queryType == 111;
    }

    public boolean isConstructType() {
        return this.queryType == 222;
    }

    public boolean isDescribeType() {
        return this.queryType == 333;
    }

    public boolean isAskType() {
        return this.queryType == 444;
    }

    public boolean isUnknownType() {
        return this.queryType == -123;
    }

    public boolean isQueryResultStar() {
        return this.queryResultStar;
    }

    public void setQueryResultStar(boolean bl) {
        this.queryResultStar = bl;
    }

    public void setQueryElement(Element element) {
        if (this.queryBlock == null) {
            this.queryBlock = new ElementBlock(null, null);
        }
        this.queryBlock.setPatternElement(element);
    }

    public void setQueryBlock(ElementBlock elementBlock) {
        this.queryBlock = elementBlock;
    }

    public ElementBlock getQueryBlock() {
        return this.queryBlock;
    }

    public void addGraphURI(String string) {
        if (this.graphURIs == null) {
            this.graphURIs = new ArrayList();
        }
        this.graphURIs.add(string);
    }

    public void addNamedGraphURI(String string) {
        if (this.namedGraphURIs == null) {
            this.namedGraphURIs = new ArrayList();
        }
        this.namedGraphURIs.add(string);
    }

    public List getGraphURIs() {
        return this.graphURIs;
    }

    public List getNamedGraphURIs() {
        return this.namedGraphURIs;
    }

    public boolean hasDatasetDescription() {
        if (this.getGraphURIs() != null && this.getGraphURIs().size() > 0) {
            return true;
        }
        return this.getNamedGraphURIs() != null && this.getNamedGraphURIs().size() > 0;
    }

    public List getResultVars() {
        return this.resultVars;
    }

    public void addResultVar(String string) {
        if (!this.resultVars.contains(string)) {
            this.resultVars.add(string);
        }
    }

    public void addResultVar(Node node) {
        if (!node.isVariable()) {
            throw new QueryException("Not a variable: " + node);
        }
        this.addResultVar(node.getName());
    }

    public void addDescribeNode(Node node) {
        if (node.isVariable()) {
            this.addResultVar(node);
            return;
        }
        if (node.isURI()) {
            this.addResultURIs(node);
            return;
        }
        if (node.isLiteral()) {
            throw new QueryException("Result node is a literal: " + FmtUtils.stringForNode(node));
        }
        throw new QueryException("Result node not recognized: " + FmtUtils.stringForNode(node));
    }

    public Template getConstructTemplate() {
        return this.constructTemplate;
    }

    public void setConstructTemplate(Template template) {
        this.constructTemplate = template;
    }

    public List getResultURIs() {
        return this.resultNodes;
    }

    public void addResultURIs(Node node) {
        if (node.isLiteral()) {
            throw new QueryException("Result URI is a literal: " + FmtUtils.stringForNode(node));
        }
        if (!this.resultNodes.contains(node)) {
            this.resultNodes.add(node);
        }
    }

    public boolean explicitlySetBaseURI() {
        return this.seenBaseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
        this.seenBaseURI = true;
    }

    void initParserBaseURI() {
        this.initParserBaseURI(null);
    }

    void initParserBaseURI(String string) {
        if (this.baseURI != null) {
            return;
        }
        this.baseURI = RelURI.chooseBaseURI(string);
    }

    public void setPrefix(String string, String string2) {
        try {
            this.prefixMap.setNsPrefix(string, string2);
        }
        catch (PrefixMapping.IllegalPrefixException illegalPrefixException) {
            log.warn((Object)("Illegal prefix mapping(ignored): " + string + "=>" + string2));
        }
    }

    public PrefixMapping getPrefixMap() {
        return this.getPrefixMapping();
    }

    public PrefixMapping getPrefixMapping() {
        return this.prefixMap;
    }

    public void setPrefixMapping(PrefixMapping prefixMapping) {
        this.prefixMap = prefixMapping;
    }

    public String getPrefix(String string) {
        return this.prefixMap.getNsPrefixURI(string);
    }

    public String expandQName(String string) {
        String string2 = this.prefixMap.expandPrefix(string);
        if (string2.equals(string)) {
            return null;
        }
        return string2;
    }

    public String shortForm(String string) {
        return this.prefixMap.shortForm(string);
    }

    public void visit(QueryVisitor queryVisitor) {
        queryVisitor.startVisit(this);
        queryVisitor.visitResultForm(this);
        queryVisitor.visitBase(this);
        queryVisitor.visitPrefixes(this);
        if (this.isSelectType()) {
            queryVisitor.visitSelectResultForm(this);
        }
        if (this.isConstructType()) {
            queryVisitor.visitConstructResultForm(this);
        }
        if (this.isDescribeType()) {
            queryVisitor.visitDescribeResultForm(this);
        }
        if (this.isAskType()) {
            queryVisitor.visitAskResultForm(this);
        }
        queryVisitor.visitDatasetDecl(this);
        queryVisitor.visitQueryPattern(this);
        queryVisitor.visitOrderBy(this);
        queryVisitor.visitLimit(this);
        queryVisitor.visitOffset(this);
        queryVisitor.finishVisit(this);
    }

    public String toString() {
        return this.serialize();
    }

    public String serialize() {
        IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
        this.serialize(indentedLineBuffer);
        return indentedLineBuffer.toString();
    }

    public void serialize(OutputStream outputStream) {
        Serializer.serialize(this, outputStream);
    }

    public void serialize(OutputStream outputStream, Syntax syntax) {
        Serializer.serialize(this, outputStream, syntax);
    }

    public void serialize(IndentedLineBuffer indentedLineBuffer) {
        Serializer.serialize(this, indentedLineBuffer);
    }

    public void serialize(IndentedLineBuffer indentedLineBuffer, Syntax syntax) {
        Serializer.serialize(this, indentedLineBuffer, syntax);
    }

    public void serialize(IndentedWriter indentedWriter) {
        Serializer.serialize(this, indentedWriter);
    }

    public void serialize(IndentedWriter indentedWriter, Syntax syntax) {
        Serializer.serialize(this, indentedWriter, syntax);
    }
}

