/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.core.DataSourceImpl;
import com.hp.hpl.jena.query.engine.QueryEngineFactory;
import com.hp.hpl.jena.query.engine.QueryEngineRegistry;
import com.hp.hpl.jena.query.engineHTTP.QueryEngineHTTP;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.util.FileManager;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryExecutionFactory {
    private static Log log = LogFactory.getLog((Class)QueryExecutionFactory.class);

    private QueryExecutionFactory() {
    }

    public static QueryExecution create(Query query2) {
        return QueryExecutionFactory.make(query2, null);
    }

    public static QueryExecution create(Query query2, Dataset dataset) {
        return QueryExecutionFactory.make(query2, dataset);
    }

    public static QueryExecution create(Query query2, FileManager fileManager) {
        QueryExecution queryExecution = QueryExecutionFactory.make(query2);
        if (fileManager != null) {
            queryExecution.setFileManager(fileManager);
        }
        return queryExecution;
    }

    public static QueryExecution create(Query query2, Model model) {
        return QueryExecutionFactory.make(query2, new DataSourceImpl(model));
    }

    public static QueryExecution create(Query query2, Model model, QuerySolution querySolution) {
        return QueryExecutionFactory.create(query2, new DataSourceImpl(model), querySolution);
    }

    public static QueryExecution create(Query query2, QuerySolution querySolution) {
        QueryExecution queryExecution = QueryExecutionFactory.make(query2);
        if (querySolution != null) {
            queryExecution.setInitialBinding(querySolution);
        }
        return queryExecution;
    }

    public static QueryExecution create(Query query2, Dataset dataset, QuerySolution querySolution) {
        QueryExecution queryExecution = QueryExecutionFactory.make(query2, dataset);
        if (querySolution != null) {
            queryExecution.setInitialBinding(querySolution);
        }
        return queryExecution;
    }

    private static QueryExecution make(Query query2) {
        return QueryExecutionFactory.make(query2, null);
    }

    public static QueryExecution create(String string, Query query2) {
        return QueryExecutionFactory.make(string, query2);
    }

    public static QueryExecution create(String string, Query query2, String string2) {
        QueryEngineHTTP queryEngineHTTP = QueryExecutionFactory.make(string, query2);
        queryEngineHTTP.addDefaultGraph(string2);
        return queryEngineHTTP;
    }

    public static QueryExecution create(String string, Query query2, List list, List list2) {
        QueryEngineHTTP queryEngineHTTP = QueryExecutionFactory.make(string, query2);
        if (list != null) {
            queryEngineHTTP.setDefaultGraphURIs(list);
        }
        if (list2 != null) {
            queryEngineHTTP.setNamedGraphURIs(list2);
        }
        return queryEngineHTTP;
    }

    private static QueryEngineHTTP make(String string, Query query2) {
        return new QueryEngineHTTP(string, query2);
    }

    private static QueryExecution make(Query query2, Dataset dataset) {
        QueryEngineFactory queryEngineFactory = QueryEngineRegistry.get().find(query2, dataset);
        if (queryEngineFactory == null) {
            log.warn((Object)("Failed to find a QueryEngineFactory for query: " + query2));
            return null;
        }
        return queryEngineFactory.create(query2, dataset);
    }
}

