/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.parser.Parser;
import com.hp.hpl.jena.util.FileManager;

public class QueryFactory {
    public static Query create(String string) {
        return QueryFactory.create(string, Syntax.defaultSyntax);
    }

    public static Query create(String string, Syntax syntax) {
        return QueryFactory.create(string, null, syntax);
    }

    public static Query create(String string, String string2, Syntax syntax) {
        Query query2 = new Query();
        QueryFactory.parse(query2, string, string2, syntax);
        return query2;
    }

    public static Query make() {
        return new Query();
    }

    public static Query parse(Query query2, String string, String string2, Syntax syntax) {
        if (syntax == null) {
            syntax = query2.getSyntax();
        } else {
            query2.setSyntax(syntax);
        }
        Parser parser = Parser.createParser(syntax);
        if (parser == null) {
            throw new UnsupportedOperationException("Unrecognized syntax for parsing: " + syntax);
        }
        query2.initParserBaseURI(string2);
        return parser.parse(query2, string);
    }

    static boolean knownParserSyntax(Syntax syntax) {
        Parser parser = Parser.createParser(syntax);
        return parser != null;
    }

    public static Query read(String string) {
        return QueryFactory.read(string, null, null, null);
    }

    public static Query read(String string, String string2) {
        return QueryFactory.read(string, null, string2, null);
    }

    public static Query read(String string, String string2, Syntax syntax) {
        return QueryFactory.read(string, null, string2, syntax);
    }

    public static Query read(String string, FileManager fileManager, String string2, Syntax syntax) {
        if (fileManager == null) {
            fileManager = FileManager.get();
        }
        String string3 = fileManager.readWholeFileAsUTF8(string);
        if (string2 == null) {
            string2 = string;
        }
        if (syntax == null) {
            syntax = Syntax.guessQueryFileSyntax(string);
        }
        return QueryFactory.create(string3, string2, syntax);
    }
}

