/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprVisitor;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.IndentedWriter;

public class SortCondition {
    public Expr expression = null;
    public Node variable = null;
    public int direction = 0;

    public SortCondition(Node node, int n) {
        this.variable = node;
        this.direction = n;
    }

    public SortCondition(Expr expr, int n) {
        this.expression = expr;
        this.direction = n;
    }

    public SortCondition(String string, int n) {
        this.variable = Node.createVariable((String)string);
        this.direction = n;
    }

    public void format(ExprVisitor exprVisitor, IndentedWriter indentedWriter) {
        boolean bl;
        boolean bl2 = true;
        boolean bl3 = bl = this.direction != Query.ASCENDING ? true : bl2;
        if (bl && this.direction == Query.ASCENDING) {
            indentedWriter.print("ASC(");
        }
        if (bl && this.direction == Query.DESCENDING) {
            indentedWriter.print("DESC(");
        }
        if (this.expression != null) {
            this.expression.visit(exprVisitor);
        } else {
            indentedWriter.print(FmtUtils.stringForNode(this.variable));
        }
        if (bl) {
            indentedWriter.print(")");
        }
    }
}

