/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Lock;
import com.hp.hpl.jena.query.core.DataSourceGraph;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.util.LockMRSW;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class DataSourceGraphImpl
implements DataSourceGraph {
    Graph activeGraph = null;
    Graph defaultGraph = null;
    Map namedGraphs = null;
    Lock lock = null;

    public DataSourceGraphImpl(Dataset dataset) {
        this.cloneDataset(dataset);
    }

    public DataSourceGraphImpl(DatasetGraph datasetGraph) {
        this.cloneDatasetGraph(datasetGraph);
    }

    public DataSourceGraphImpl() {
    }

    public Graph getDefaultGraph() {
        return this.defaultGraph;
    }

    public void setDefaultGraph(Graph graph) {
        if (this.activeGraph == null) {
            this.activeGraph = graph;
        }
        this.defaultGraph = graph;
    }

    public Graph getActiveGraph() {
        return this.activeGraph;
    }

    public void setActiveGraph(Graph graph) {
        this.activeGraph = graph;
    }

    public Graph getNamedGraph(String string) {
        if (this.namedGraphs == null) {
            return null;
        }
        return (Graph)this.namedGraphs.get(string);
    }

    public void addNamedGraph(String string, Graph graph) {
        if (this.namedGraphs == null) {
            this.namedGraphs = new HashMap();
        }
        this.namedGraphs.put(string, graph);
    }

    public boolean containsNamedGraph(String string) {
        return this.namedGraphs.containsKey(string);
    }

    public Iterator listNames() {
        if (this.namedGraphs == null) {
            return new NullIterator();
        }
        return this.namedGraphs.keySet().iterator();
    }

    public Lock getLock() {
        if (this.lock == null) {
            this.lock = new LockMRSW();
        }
        return this.lock;
    }

    private void cloneDataset(Dataset dataset) {
        if (dataset == null) {
            return;
        }
        if (dataset.getDefaultModel() != null) {
            this.activeGraph = this.defaultGraph = dataset.getDefaultModel().getGraph();
        }
        Iterator iterator = dataset.listNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Model model = dataset.getNamedModel(string);
            if (model == null) continue;
            this.addNamedGraph(string, model.getGraph());
        }
    }

    private void cloneDatasetGraph(DatasetGraph datasetGraph) {
        if (!(datasetGraph instanceof DataSourceGraphImpl)) {
            LogFactory.getLog((Class)DataSourceGraphImpl.class).fatal((Object)"Clone DatasetGraph: only DataSourceGraphImpl supported");
            return;
        }
        DataSourceGraphImpl dataSourceGraphImpl = (DataSourceGraphImpl)datasetGraph;
        this.namedGraphs = new HashMap(dataSourceGraphImpl.namedGraphs);
        this.defaultGraph = dataSourceGraphImpl.defaultGraph;
    }

    public String toString() {
        String string = "{";
        string = this.getDefaultGraph() == null ? string + "<null>" : string + "[" + this.getDefaultGraph().size() + "]";
        Iterator iterator = this.listNames();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            string = string + ", (" + string2 + ", [" + this.getNamedGraph(string2).size() + "])";
        }
        string = string + "}";
        return string;
    }
}

