/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.LabelExistsException;
import com.hp.hpl.jena.query.Lock;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.util.LockMRSW;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class DataSourceImpl
implements DataSource {
    Model defaultModel = null;
    Map namedModels = new HashMap();
    Lock lock = new LockMRSW();

    public DataSourceImpl() {
    }

    public DataSourceImpl(Dataset dataset) {
        if (!(dataset instanceof DataSourceImpl)) {
            LogFactory.getLog((Class)DataSourceImpl.class).fatal((Object)"Clone Dataset: only DataSourceImpl supported");
            return;
        }
        DataSourceImpl dataSourceImpl = (DataSourceImpl)dataset;
        this.namedModels.putAll(dataSourceImpl.namedModels);
        this.defaultModel = dataSourceImpl.defaultModel;
    }

    public DataSourceImpl(DatasetGraph datasetGraph) {
        this.cloneFromDatasetGraph(datasetGraph);
    }

    public DataSourceImpl(Model model) {
        this();
        this.setDefaultModel(model);
    }

    public Model getDefaultModel() {
        return this.defaultModel;
    }

    public Model getNamedModel(String string) {
        return (Model)this.namedModels.get(string);
    }

    public boolean containsNamedModel(String string) {
        return this.namedModels.containsKey(string);
    }

    public Iterator listNames() {
        return this.namedModels.keySet().iterator();
    }

    public void close() {
        Iterator iterator = this.listNames();
        while (iterator.hasNext()) {
            Model model = (Model)iterator.next();
            model.close();
        }
        this.namedModels.clear();
        if (this.defaultModel != null) {
            this.defaultModel.close();
        }
    }

    public void setDefaultModel(Model model) {
        this.defaultModel = model;
    }

    public void addNamedModel(String string, Model model) throws LabelExistsException {
        if (this.namedModels.containsKey(string)) {
            throw new LabelExistsException("URI: " + string);
        }
        this.namedModels.put(string, model);
    }

    public void removeNamedModel(String string) {
        this.removeNamedGraph(string);
    }

    public void removeNamedGraph(String string) {
        this.namedModels.remove(string);
    }

    public void replaceNamedModel(String string, Model model) {
        this.removeNamedModel(string);
        this.addNamedModel(string, model);
    }

    public String toString() {
        String string = "{";
        string = this.getDefaultModel() == null ? string + "<null>" : string + "[" + this.getDefaultModel().size() + "]";
        Iterator iterator = this.listNames();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            string = string + ", (" + string2 + ", [" + this.getNamedModel(string2).size() + "])";
        }
        string = string + "}";
        return string;
    }

    public Lock getLock() {
        return this.lock;
    }

    private void cloneFromDatasetGraph(DatasetGraph datasetGraph) {
        if (datasetGraph.getDefaultGraph() != null) {
            this.defaultModel = ModelFactory.createModelForGraph((Graph)datasetGraph.getDefaultGraph());
        }
        Iterator iterator = datasetGraph.listNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Graph graph = datasetGraph.getNamedGraph(string);
            if (graph == null) continue;
            Model model = ModelFactory.createModelForGraph((Graph)graph);
            this.addNamedModel(string, model);
        }
    }
}

