/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.ElementExtension;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.ElementUnsaid;
import com.hp.hpl.jena.query.core.ElementVisitor;
import java.util.Iterator;
import java.util.ListIterator;

public class ElementWalker
implements ElementVisitor {
    ElementVisitor proc;

    public ElementWalker(ElementVisitor elementVisitor) {
        this.proc = elementVisitor;
    }

    public void walk(Element element) {
        element.visit(this);
    }

    public static void walk(Element element, ElementVisitor elementVisitor) {
        new ElementWalker(elementVisitor).walk(element);
    }

    public void visit(ElementTriplePattern elementTriplePattern) {
        this.proc.visit(elementTriplePattern);
    }

    public void visit(ElementBlock elementBlock) {
        if (elementBlock.getPatternElement() != null) {
            elementBlock.getPatternElement().visit(this);
        }
        this.proc.visit(elementBlock);
    }

    public void visit(ElementFilter elementFilter) {
        this.proc.visit(elementFilter);
    }

    public void visit(ElementUnion elementUnion) {
        ListIterator listIterator = elementUnion.getElements().listIterator();
        while (listIterator.hasNext()) {
            Element element = (Element)listIterator.next();
            element.visit(this);
        }
        this.proc.visit(elementUnion);
    }

    public void visit(ElementGroup elementGroup) {
        Iterator iterator = elementGroup.getElements().iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            element.visit(this);
        }
        this.proc.visit(elementGroup);
    }

    public void visit(ElementOptional elementOptional) {
        if (elementOptional.getElement() != null) {
            elementOptional.getElement().visit(this);
        }
        this.proc.visit(elementOptional);
    }

    public void visit(ElementNamedGraph elementNamedGraph) {
        if (elementNamedGraph.getElement() != null) {
            elementNamedGraph.getElement().visit(this);
        }
        this.proc.visit(elementNamedGraph);
    }

    public void visit(ElementUnsaid elementUnsaid) {
        if (elementUnsaid.getElement() != null) {
            elementUnsaid.getElement().visit(this);
        }
        this.proc.visit(elementUnsaid);
    }

    public void visit(ElementExtension elementExtension) {
        this.proc.visit(elementExtension);
    }
}

