/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.ElementUnsaid;
import com.hp.hpl.jena.query.core.ElementVisitor;
import java.util.ListIterator;

public abstract class RecursiveVisitor
implements ElementVisitor {
    public void startElement(ElementBlock elementBlock) {
    }

    public void endElement(ElementBlock elementBlock) {
    }

    public void startElement(ElementFilter elementFilter) {
    }

    public void endElement(ElementFilter elementFilter) {
    }

    public void startElement(ElementUnion elementUnion) {
    }

    public void endElement(ElementUnion elementUnion) {
    }

    public void startSubElement(ElementUnion elementUnion, Element element) {
    }

    public void endSubElement(ElementUnion elementUnion, Element element) {
    }

    public void startElement(ElementGroup elementGroup) {
    }

    public void endElement(ElementGroup elementGroup) {
    }

    public void startSubElement(ElementGroup elementGroup, Element element) {
    }

    public void endSubElement(ElementGroup elementGroup, Element element) {
    }

    public void startElement(ElementOptional elementOptional) {
    }

    public void endElement(ElementOptional elementOptional) {
    }

    public void startElement(ElementNamedGraph elementNamedGraph) {
    }

    public void endElement(ElementNamedGraph elementNamedGraph) {
    }

    public void startElement(ElementUnsaid elementUnsaid) {
    }

    public void endElement(ElementUnsaid elementUnsaid) {
    }

    public void visit(ElementBlock elementBlock) {
        this.startElement(elementBlock);
        elementBlock.getPatternElement().visit(this);
        this.endElement(elementBlock);
    }

    public void visit(ElementFilter elementFilter) {
        this.startElement(elementFilter);
        this.endElement(elementFilter);
    }

    public void visit(ElementUnion elementUnion) {
        this.startElement(elementUnion);
        ListIterator listIterator = elementUnion.elements.listIterator();
        while (listIterator.hasNext()) {
            Element element = (Element)listIterator.next();
            this.startSubElement(elementUnion, element);
            element.visit(this);
            this.endSubElement(elementUnion, element);
        }
        this.endElement(elementUnion);
    }

    public void visit(ElementGroup elementGroup) {
        this.startElement(elementGroup);
        ListIterator listIterator = elementGroup.elements.listIterator();
        while (listIterator.hasNext()) {
            Element element = (Element)listIterator.next();
            this.startSubElement(elementGroup, element);
            element.visit(this);
            this.endSubElement(elementGroup, element);
        }
        this.endElement(elementGroup);
    }

    public void visit(ElementOptional elementOptional) {
        this.startElement(elementOptional);
        elementOptional.getElement().visit(this);
        this.endElement(elementOptional);
    }

    public void visit(ElementNamedGraph elementNamedGraph) {
        this.startElement(elementNamedGraph);
        elementNamedGraph.getElement().visit(this);
        this.endElement(elementNamedGraph);
    }

    public void visit(ElementUnsaid elementUnsaid) {
        this.startElement(elementUnsaid);
        elementUnsaid.getElement().visit(this);
        this.endElement(elementUnsaid);
    }
}

