/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.ElementVisitorBase;
import java.util.Set;

public class VarsMentionedVisitor
extends ElementVisitorBase
implements ElementVisitor {
    Set acc;

    public VarsMentionedVisitor(Set set) {
        this.acc = set;
    }

    public void visit(ElementTriplePattern elementTriplePattern) {
        Triple triple = elementTriplePattern.getTriple();
        VarsMentionedVisitor.addVarsFromTriple(this.acc, triple);
    }

    public void visit(ElementFilter elementFilter) {
        elementFilter.getConstraint().varsMentioned(this.acc);
    }

    public void visit(ElementNamedGraph elementNamedGraph) {
        VarsMentionedVisitor.addVar(this.acc, elementNamedGraph.getGraphNameNode());
    }

    private static void addVarsFromTriple(Set set, Triple triple) {
        VarsMentionedVisitor.addVar(set, triple.getSubject());
        VarsMentionedVisitor.addVar(set, triple.getPredicate());
        VarsMentionedVisitor.addVar(set, triple.getObject());
    }

    private static void addVar(Set set, Node node) {
        if (node == null) {
            return;
        }
        if (node.isVariable()) {
            set.add(node.getName());
        }
    }
}

