/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.engine.QueryEngineFactory;
import com.hp.hpl.jena.query.engine1.DefaultEngineFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class QueryEngineRegistry {
    List factories = new ArrayList();
    static QueryEngineRegistry registry;

    public static QueryEngineRegistry get() {
        if (registry == null) {
            QueryEngineRegistry.init();
        }
        return registry;
    }

    private QueryEngineRegistry() {
    }

    public static void init() {
        registry = new QueryEngineRegistry();
        registry.add(new DefaultEngineFactory());
    }

    public static QueryEngineFactory findFactory(Query query2, Dataset dataset) {
        return QueryEngineRegistry.get().find(query2, dataset);
    }

    public QueryEngineFactory find(Query query2, Dataset dataset) {
        ListIterator listIterator = this.factories.listIterator();
        while (listIterator.hasNext()) {
            QueryEngineFactory queryEngineFactory = (QueryEngineFactory)listIterator.next();
            if (!queryEngineFactory.accept(query2, dataset)) continue;
            return queryEngineFactory;
        }
        return null;
    }

    public static void addFactory(QueryEngineFactory queryEngineFactory) {
        QueryEngineRegistry.get().add(queryEngineFactory);
    }

    public void add(QueryEngineFactory queryEngineFactory) {
        this.factories.add(0, queryEngineFactory);
    }

    public static void removeFactory(QueryEngineFactory queryEngineFactory) {
        QueryEngineRegistry.get().remove(queryEngineFactory);
    }

    public void remove(QueryEngineFactory queryEngineFactory) {
        this.factories.remove(queryEngineFactory);
    }

    public List factories() {
        return this.factories;
    }

    public static boolean containsFactory(QueryEngineFactory queryEngineFactory) {
        return QueryEngineRegistry.get().contains(queryEngineFactory);
    }

    public boolean contains(QueryEngineFactory queryEngineFactory) {
        return this.factories.contains(queryEngineFactory);
    }

    static {
        QueryEngineRegistry.init();
        registry = null;
    }
}

