/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Constraint;
import com.hp.hpl.jena.query.engine1.Plan;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.compiler.PlanBasePattern;
import com.hp.hpl.jena.query.engine1.compiler.PlanBlock;
import com.hp.hpl.jena.query.engine1.compiler.PlanDistinct;
import com.hp.hpl.jena.query.engine1.compiler.PlanExtension;
import com.hp.hpl.jena.query.engine1.compiler.PlanFilter;
import com.hp.hpl.jena.query.engine1.compiler.PlanGroup;
import com.hp.hpl.jena.query.engine1.compiler.PlanLimitOffset;
import com.hp.hpl.jena.query.engine1.compiler.PlanNamedGraph;
import com.hp.hpl.jena.query.engine1.compiler.PlanOptional;
import com.hp.hpl.jena.query.engine1.compiler.PlanOrderBy;
import com.hp.hpl.jena.query.engine1.compiler.PlanOuterJoin;
import com.hp.hpl.jena.query.engine1.compiler.PlanProject;
import com.hp.hpl.jena.query.engine1.compiler.PlanTriplePattern;
import com.hp.hpl.jena.query.engine1.compiler.PlanUnion;
import com.hp.hpl.jena.query.engine1.compiler.PlanUnsaid;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.serializer.FmtExprARQ;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;

public class PlanFormatter
implements PlanVisitor {
    static final int INDENT = 2;
    IndentedWriter out;
    SerializationContext context;
    private static boolean defaultClosingBracketOnSameLine = true;
    private boolean closingBracketOnSameLine = defaultClosingBracketOnSameLine;

    public static void out(OutputStream outputStream, Plan plan) {
        PlanFormatter.out(outputStream, plan.getRoot());
    }

    public static void out(IndentedWriter indentedWriter, Plan plan) {
        PlanFormatter.out(indentedWriter, plan.getRoot());
    }

    public static void out(OutputStream outputStream, Query query2, Plan plan) {
        PlanFormatter.out(outputStream, plan.getRoot());
    }

    public static void out(OutputStream outputStream, PrefixMapping prefixMapping, Plan plan) {
        PlanFormatter.out(outputStream, prefixMapping, plan.getRoot());
    }

    public static void out(IndentedWriter indentedWriter, PlanElement planElement) {
        PlanFormatter.out(indentedWriter, (PrefixMapping)null, planElement);
    }

    public static void out(OutputStream outputStream, PlanElement planElement) {
        PlanFormatter.out(outputStream, (PrefixMapping)null, planElement);
    }

    public static void out(OutputStream outputStream, PrefixMapping prefixMapping, PlanElement planElement) {
        IndentedWriter indentedWriter = new IndentedWriter(outputStream);
        PlanFormatter.out(indentedWriter, prefixMapping, planElement);
    }

    public static void out(OutputStream outputStream, Query query2, PlanElement planElement) {
        IndentedWriter indentedWriter = new IndentedWriter(outputStream);
        PlanFormatter.out(indentedWriter, query2, planElement);
    }

    public static void out(IndentedWriter indentedWriter, Query query2, PlanElement planElement) {
        PrefixMapping prefixMapping = null;
        if (query2 != null && query2.getPrefixMapping() != null) {
            prefixMapping = query2.getPrefixMapping();
        }
        PlanFormatter.out(indentedWriter, prefixMapping, planElement);
    }

    public static void out(IndentedWriter indentedWriter, PrefixMapping prefixMapping, PlanElement planElement) {
        PlanFormatter planFormatter = new PlanFormatter(indentedWriter, prefixMapping);
        planFormatter.startVisit();
        planElement.visit(planFormatter);
        planFormatter.finishVisit();
    }

    private void startVisit() {
    }

    private void finishVisit() {
        this.out.newline();
        this.out.flush();
    }

    public PlanFormatter(IndentedWriter indentedWriter, PrefixMapping prefixMapping) {
        this(indentedWriter, new SerializationContext(prefixMapping));
    }

    public PlanFormatter(IndentedWriter indentedWriter, SerializationContext serializationContext) {
        this.out = indentedWriter;
        this.context = serializationContext;
        this.closingBracketOnSameLine = defaultClosingBracketOnSameLine;
    }

    public void visit(PlanBasePattern planBasePattern) {
        this.out.print("[");
        this.out.print("BasePattern");
        if (planBasePattern.getPattern().size() == 1) {
            this.out.print(" ");
            Triple triple = (Triple)planBasePattern.getPattern().get(0);
            this.formatTriple(triple);
            this.finish();
            return;
        }
        this.out.incIndent(2);
        Iterator iterator = planBasePattern.getPattern().iterator();
        while (iterator.hasNext()) {
            this.out.newline();
            Triple triple = (Triple)iterator.next();
            this.formatTriple(triple);
        }
        if (this.closingBracketOnSameLine) {
            this.out.newline();
        }
        this.out.decIndent(2);
        this.finish();
    }

    public void visit(PlanTriplePattern planTriplePattern) {
        this.out.print("[");
        this.out.print("TriplePattern");
        this.out.print(" ");
        Triple triple = planTriplePattern.getTriple();
        this.formatTriple(triple);
        this.finish();
    }

    public void visit(PlanGroup planGroup) {
        String string = "Group";
        if (!planGroup.canReorder()) {
            string = "Group(fixed)";
        }
        this.multipleSubPlans(string, planGroup.getPlanElements().iterator());
    }

    public void visit(PlanUnion planUnion) {
        this.multipleSubPlans("Union", planUnion.getPlanElements().iterator());
    }

    public void visit(PlanOptional planOptional) {
        this.singleSubPlan("Optional", planOptional.getSub());
    }

    public void visit(PlanUnsaid planUnsaid) {
        this.singleSubPlan("Unsaid", planUnsaid.getSub());
    }

    public void visit(PlanFilter planFilter) {
        this.out.print("[");
        this.out.print("Constraint");
        this.out.print(" ");
        Constraint constraint = planFilter.getConstraint();
        if (constraint instanceof Expr) {
            Expr expr = (Expr)constraint;
            FmtExprARQ fmtExprARQ = new FmtExprARQ(this.out, this.context);
            expr.visit(fmtExprARQ);
        } else {
            this.out.print(constraint.toString());
        }
        this.out.print("]");
    }

    public void visit(PlanNamedGraph planNamedGraph) {
        this.singleSubPlan("NamedGraph", planNamedGraph.getSub());
    }

    public void visit(PlanOuterJoin planOuterJoin) {
        this.multipleSubPlans("OuterJoin", planOuterJoin.getPlanElements().iterator());
    }

    public void visit(PlanExtension planExtension) {
        this.plainPlan("Extension");
    }

    public void visit(PlanBlock planBlock) {
        this.singleSubPlan("Block", planBlock.getSub());
    }

    public void visit(PlanDistinct planDistinct) {
        this.singleSubPlan("Distinct", planDistinct.getSub(), planDistinct.getVars());
    }

    public void visit(PlanProject planProject) {
        this.singleSubPlan("Project", planProject.getSub(), planProject.getVars());
    }

    public void visit(PlanOrderBy planOrderBy) {
        this.singleSubPlan("OrderBy", planOrderBy.getSub());
    }

    public void visit(PlanLimitOffset planLimitOffset) {
        this.singleSubPlan("LimitOffset", planLimitOffset.getSub());
    }

    private void plainPlan(String string) {
        this.out.print("[");
        this.out.print(string);
        this.finish();
    }

    private void singleSubPlan(String string, PlanElement planElement) {
        this.singleSubPlan(string, planElement, null);
    }

    private void singleSubPlan(String string, PlanElement planElement, Collection collection) {
        this.out.print("[");
        this.out.print(string);
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                this.out.print(" ?");
                this.out.print(string2);
            }
        }
        this.out.incIndent(2);
        if (planElement != null) {
            this.out.println();
            planElement.visit(this);
        }
        this.out.decIndent(2);
        this.finish();
    }

    private void multipleSubPlans(String string, Iterator iterator) {
        this.out.print("[");
        this.out.print(string);
        this.out.incIndent(2);
        while (iterator.hasNext()) {
            this.out.newline();
            PlanElement planElement = (PlanElement)iterator.next();
            planElement.visit(this);
        }
        this.out.decIndent(2);
        this.finish();
    }

    private void finish() {
        if (this.closingBracketOnSameLine) {
            this.out.print("]");
        } else {
            this.out.println();
            this.out.print("]");
        }
    }

    private void formatTriple(Triple triple) {
        this.out.print(this.slotToString(triple.getSubject()));
        this.out.print(" ");
        this.out.print(this.slotToString(triple.getPredicate()));
        this.out.print(" ");
        this.out.print(this.slotToString(triple.getObject()));
    }

    private String slotToString(Node node) {
        return FmtUtils.stringForNode(node, this.context);
    }
}

