/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.compiler.PlanBasePattern;
import com.hp.hpl.jena.query.engine1.compiler.PlanBlock;
import com.hp.hpl.jena.query.engine1.compiler.PlanDistinct;
import com.hp.hpl.jena.query.engine1.compiler.PlanExtension;
import com.hp.hpl.jena.query.engine1.compiler.PlanFilter;
import com.hp.hpl.jena.query.engine1.compiler.PlanGroup;
import com.hp.hpl.jena.query.engine1.compiler.PlanLimitOffset;
import com.hp.hpl.jena.query.engine1.compiler.PlanNamedGraph;
import com.hp.hpl.jena.query.engine1.compiler.PlanOptional;
import com.hp.hpl.jena.query.engine1.compiler.PlanOrderBy;
import com.hp.hpl.jena.query.engine1.compiler.PlanOuterJoin;
import com.hp.hpl.jena.query.engine1.compiler.PlanProject;
import com.hp.hpl.jena.query.engine1.compiler.PlanTriplePattern;
import com.hp.hpl.jena.query.engine1.compiler.PlanUnion;
import com.hp.hpl.jena.query.engine1.compiler.PlanUnsaid;
import java.util.Iterator;

public class PlanWalker
implements PlanVisitor {
    PlanVisitor proc;

    public static void walk(PlanVisitor planVisitor, PlanElement planElement) {
        new PlanWalker(planVisitor).walk(planElement);
    }

    public PlanWalker(PlanVisitor planVisitor) {
        this.proc = planVisitor;
    }

    public void walk(PlanElement planElement) {
        planElement.visit(this);
    }

    public void visit(PlanBasePattern planBasePattern) {
        this.proc.visit(planBasePattern);
    }

    public void visit(PlanTriplePattern planTriplePattern) {
        this.proc.visit(planTriplePattern);
    }

    public void visit(PlanGroup planGroup) {
        Iterator iterator = planGroup.getPlanElements().iterator();
        while (iterator.hasNext()) {
            PlanElement planElement = (PlanElement)iterator.next();
            planElement.visit(this);
        }
        this.proc.visit(planGroup);
    }

    public void visit(PlanUnion planUnion) {
        Iterator iterator = planUnion.getPlanElements().iterator();
        while (iterator.hasNext()) {
            PlanElement planElement = (PlanElement)iterator.next();
            planElement.visit(this);
        }
        this.proc.visit(planUnion);
    }

    public void visit(PlanOptional planOptional) {
        if (planOptional.getSub() != null) {
            planOptional.getSub().visit(this);
        }
        this.proc.visit(planOptional);
    }

    public void visit(PlanUnsaid planUnsaid) {
        if (planUnsaid.getSub() != null) {
            planUnsaid.getSub().visit(this);
        }
        this.proc.visit(planUnsaid);
    }

    public void visit(PlanFilter planFilter) {
        this.proc.visit(planFilter);
    }

    public void visit(PlanNamedGraph planNamedGraph) {
        if (planNamedGraph.getSub() != null) {
            planNamedGraph.getSub().visit(this);
        }
        this.proc.visit(planNamedGraph);
    }

    public void visit(PlanOuterJoin planOuterJoin) {
        Iterator iterator = planOuterJoin.getPlanElements().iterator();
        while (iterator.hasNext()) {
            PlanElement planElement = (PlanElement)iterator.next();
            planElement.visit(this);
        }
        this.proc.visit(planOuterJoin);
    }

    public void visit(PlanExtension planExtension) {
        this.proc.visit(planExtension);
    }

    public void visit(PlanBlock planBlock) {
        if (planBlock.getSub() != null) {
            planBlock.getSub().visit(this);
        }
        this.proc.visit(planBlock);
    }

    public void visit(PlanProject planProject) {
        planProject.getSub().visit(this);
        this.proc.visit(planProject);
    }

    public void visit(PlanDistinct planDistinct) {
        planDistinct.getSub().visit(this);
        this.proc.visit(planDistinct);
    }

    public void visit(PlanOrderBy planOrderBy) {
        planOrderBy.getSub().visit(this);
        this.proc.visit(planOrderBy);
    }

    public void visit(PlanLimitOffset planLimitOffset) {
        planLimitOffset.getSub().visit(this);
        this.proc.visit(planLimitOffset);
    }
}

