/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Constants;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.DescribeHandler;
import com.hp.hpl.jena.query.DescribeHandlerRegistry;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.BindingMap;
import com.hp.hpl.jena.query.core.BindingRoot;
import com.hp.hpl.jena.query.core.DataSourceGraphImpl;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.ResultBinding;
import com.hp.hpl.jena.query.core.Template;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine.ResultSetStream;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.Mark;
import com.hp.hpl.jena.query.engine1.Plan;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.QueryEngineUtils;
import com.hp.hpl.jena.query.engine1.QueryIterNullIterator;
import com.hp.hpl.jena.query.engine1.QueryIterSingleton;
import com.hp.hpl.jena.query.engine1.QueryIteratorBase;
import com.hp.hpl.jena.query.engine1.compiler.PlanDistinct;
import com.hp.hpl.jena.query.engine1.compiler.PlanLimitOffset;
import com.hp.hpl.jena.query.engine1.compiler.PlanOrderBy;
import com.hp.hpl.jena.query.engine1.compiler.PlanProject;
import com.hp.hpl.jena.query.engine1.compiler.QueryPatternCompiler;
import com.hp.hpl.jena.query.util.RelURI;
import com.hp.hpl.jena.query.util.Utils;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.FileManager;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryEngine
implements QueryExecution {
    static Log log = LogFactory.getLog((Class)QueryEngine.class);
    Query query;
    Plan plan;
    static int queryCount = 0;
    boolean queryInitialised = false;
    int idQueryExecution;
    QueryIterator resultsIter;
    ExecutionContext context = new ExecutionContext();
    QuerySolution startBinding = null;
    FileManager fileManager = FileManager.get();
    Dataset dataset = null;

    public QueryEngine(Query query2) {
        this.query = query2;
        this.idQueryExecution = ++queryCount;
    }

    public Query getQuery() {
        return this.query;
    }

    public void init() {
        if (this.queryInitialised) {
            return;
        }
        DatasetGraph datasetGraph = null;
        if (this.getDataset() == null) {
            if (!(this.query.getGraphURIs() != null && this.query.getGraphURIs().size() != 0 || this.query.getNamedGraphURIs() != null && this.query.getNamedGraphURIs().size() != 0)) {
                throw new QueryException("No model for query");
            }
            String string = this.query.getBaseURI();
            if (string == null) {
                string = RelURI.chooseBaseURI();
            }
            log.debug((Object)("init: baseURI for query is: " + string));
            datasetGraph = DatasetFactory.createDatasetGraph(this.query.getGraphURIs(), this.query.getNamedGraphURIs(), this.fileManager, string);
        } else {
            log.debug((Object)"External data source for query");
            datasetGraph = new DataSourceGraphImpl(this.getDataset());
        }
        if (this.query.getQueryBlock() != null) {
            this.query.getQueryBlock().setDataset(datasetGraph);
        } else {
            this.query.setQueryBlock(new ElementBlock(datasetGraph, null));
        }
        if (this.plan == null) {
            this.plan = this.buildPlan();
        }
        this.queryInitialised = true;
    }

    public void setInitialBinding(QuerySolution querySolution) {
        this.startBinding = querySolution;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public Plan getPlan() {
        if (this.plan == null) {
            this.plan = this.buildPlan();
        }
        return this.plan;
    }

    public Model execConstruct() {
        ResultBinding resultBinding;
        QuerySolution querySolution;
        Object object;
        this.init();
        if (!this.query.isConstructType()) {
            throw new QueryException("Attempt to get a CONSTRUCT model from a " + QueryEngine.labelForQuery(this.query) + " query");
        }
        Model model = ModelFactory.createDefaultModel();
        this.insertPrefixesInto(model);
        ResultSet resultSet = this.execInternal();
        HashSet hashSet = new HashSet();
        Template template = this.query.getConstructTemplate();
        while (resultSet.hasNext()) {
            object = new HashMap();
            querySolution = resultSet.nextSolution();
            resultBinding = (ResultBinding)querySolution;
            template.subst(hashSet, (Map)object, resultBinding.getBinding());
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            querySolution = (Triple)object.next();
            resultBinding = QueryEngineUtils.tripleToStatement(model, (Triple)querySolution);
            if (resultBinding == null) continue;
            model.add((Statement)resultBinding);
        }
        this.close();
        return model;
    }

    public Model execDescribe() {
        Object object;
        Iterator iterator;
        QuerySolution querySolution;
        Iterator iterator2;
        this.init();
        if (!this.query.isDescribeType()) {
            throw new QueryException("Attempt to get a DESCRIBE result from a " + QueryEngine.labelForQuery(this.query) + " query");
        }
        Model model = ModelFactory.createDefaultModel();
        this.insertPrefixesInto(model);
        HashSet<Object> hashSet = new HashSet<Object>();
        if (this.query.getQueryBlock().getPatternElement() != null) {
            iterator2 = this.execInternal();
            while (iterator2.hasNext()) {
                querySolution = iterator2.nextSolution();
                iterator = this.query.getResultVars().iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    RDFNode rDFNode = querySolution.get((String)object);
                    hashSet.add(rDFNode);
                }
            }
        }
        if (this.query.getResultURIs() != null) {
            iterator2 = this.query.getResultURIs().iterator();
            while (iterator2.hasNext()) {
                querySolution = (Node)iterator2.next();
                iterator = QueryEngineUtils.convertGraphNodeToRDFNode((Node)querySolution, this.dataset.getDefaultModel());
                hashSet.add(iterator);
            }
        }
        iterator2 = hashSet.iterator();
        while (iterator2.hasNext()) {
            querySolution = (RDFNode)iterator2.next();
            if (!(querySolution instanceof Resource)) continue;
            iterator = DescribeHandlerRegistry.handlers();
            while (iterator.hasNext()) {
                object = (DescribeHandler)iterator.next();
                object.describe(model, (Resource)querySolution);
            }
        }
        this.close();
        return model;
    }

    public ResultSet execSelect() {
        this.init();
        if (!this.query.isSelectType()) {
            throw new QueryException("Attempt to have ResultSet from a " + QueryEngine.labelForQuery(this.query) + " query");
        }
        return this.execInternal();
    }

    public boolean execAsk() {
        if (!this.query.isAskType()) {
            throw new QueryException("Attempt to have boolean from a " + QueryEngine.labelForQuery(this.query) + " query");
        }
        ResultSet resultSet = this.execInternal();
        boolean bl = resultSet.hasNext();
        this.close();
        return bl;
    }

    private ResultSet execInternal() {
        this.resultsIter = this.planToIterator();
        ResultSetStream resultSetStream = new ResultSetStream(this.query, this.resultsIter);
        if (this.query.hasOrderBy()) {
            resultSetStream.setOrdered(true);
        }
        if (this.query.isDistinct()) {
            resultSetStream.setDistinct(true);
        }
        return resultSetStream;
    }

    protected PlanElement makePlanForQueryPattern(Plan plan) {
        return QueryPatternCompiler.makePlan(plan, this.query.getQueryBlock());
    }

    protected PlanElement queryPlanHook(Plan plan, PlanElement planElement) {
        return planElement;
    }

    private QueryIterator planToIterator() {
        QueryIterator queryIterator = null;
        try {
            Object object;
            Object object2;
            this.init();
            PlanElement planElement = this.getPlan().getRoot();
            Mark mark = new Mark(0, 0);
            Binding binding = this.makeRootBinding();
            QueryIterSingleton queryIterSingleton = null;
            if (this.startBinding != null) {
                object2 = null;
                object2 = new BindingMap(binding);
                object = this.startBinding.varNames();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    RDFNode rDFNode = this.startBinding.get(string);
                    ((Binding)object2).add(string, rDFNode.asNode());
                }
                queryIterSingleton = new QueryIterSingleton(mark, (Binding)object2, this.context);
            }
            if (queryIterSingleton == null) {
                queryIterSingleton = new QueryIterSingleton(mark, binding, this.context);
            }
            object2 = new DataSourceGraphImpl(this.dataset);
            queryIterator = planElement.exec(mark, queryIterSingleton, this.context, (DatasetGraph)object2);
            object = this.query.getQueryBlock();
            if (object == null) {
                return new QueryIterNullIterator(this.context);
            }
            ((ElementBlock)object).setDataset((DatasetGraph)object2);
            return queryIterator;
        }
        catch (RuntimeException runtimeException) {
            if (queryIterator != null) {
                queryIterator.close();
            }
            throw runtimeException;
        }
    }

    private Binding makeRootBinding() {
        BindingRoot bindingRoot = Binding.createRootBinding();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        String string = Utils.calendarToXSDDateTimeString(gregorianCalendar);
        Node node = Node.createLiteral((String)string, null, (RDFDatatype)XSDDatatype.XSDdateTime);
        bindingRoot.add(Constants.varCurrentTime, node);
        return bindingRoot;
    }

    private Plan buildPlan() {
        if (this.plan != null) {
            return this.plan;
        }
        this.plan = new Plan();
        PlanElement planElement = this.makePlanForQueryPattern(this.plan);
        planElement = this.queryPlanHook(this.plan, planElement);
        this.plan.setRoot(planElement);
        if (this.query.hasOrderBy()) {
            planElement = PlanOrderBy.make(this.plan, planElement, this.query.getOrderBy());
        }
        if (!this.query.isQueryResultStar()) {
            if (this.query.getResultVars().size() == 0 && this.query.isSelectType()) {
                log.warn((Object)"No project variables");
            }
            planElement = PlanProject.make(this.plan, planElement, this.query.getResultVars());
        }
        if (this.query.isDistinct()) {
            planElement = PlanDistinct.make(this.plan, planElement, this.query.getResultVars());
        }
        if (this.query.hasLimit() || this.query.hasOffset()) {
            planElement = PlanLimitOffset.make(this.plan, planElement, this.query.getLimit(), this.query.getOffset());
        }
        this.plan.setRoot(planElement);
        return this.plan;
    }

    public void abort() {
        this.close(true);
    }

    public void close() {
        this.close(true);
    }

    private void close(boolean bl) {
        if (bl) {
            if (this.resultsIter != null) {
                this.resultsIter.close();
            }
            this.resultsIter = null;
        }
        Iterator iterator = this.context.listOpenIterators();
        while (iterator.hasNext()) {
            QueryIterator queryIterator = (QueryIterator)iterator.next();
            if (queryIterator instanceof QueryIteratorBase) {
                QueryIteratorBase queryIteratorBase = (QueryIteratorBase)queryIterator;
                log.warn((Object)("Open iterator: " + queryIteratorBase.iteratorNumber + " " + queryIterator));
                continue;
            }
            log.warn((Object)("Open iterator: " + queryIterator));
        }
        if (this.resultsIter != null) {
            this.resultsIter.close();
        }
        this.resultsIter = null;
    }

    private void insertPrefixesInto(Model model) {
        try {
            PrefixMapping prefixMapping = this.query.getQueryBlock().getDataset().getDefaultGraph().getPrefixMapping();
            model.setNsPrefixes(prefixMapping);
            model.setNsPrefixes(this.query.getPrefixMapping());
        }
        catch (Exception exception) {
            log.warn((Object)("Exception in insertPrefixes: " + exception.getMessage()));
        }
    }

    private static String labelForQuery(Query query2) {
        if (query2.isSelectType()) {
            return "SELECT";
        }
        if (query2.isConstructType()) {
            return "CONSTRUCT";
        }
        if (query2.isDescribeType()) {
            return "DESCRIBE";
        }
        if (query2.isAskType()) {
            return "ASK";
        }
        return "<<unknown>>";
    }
}

