/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.BindingMap;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.Mark;
import com.hp.hpl.jena.query.engine1.QueryEngineUtils;
import com.hp.hpl.jena.query.engine1.QueryIterRepeatApply;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryIterBasePattern
extends QueryIterRepeatApply {
    static Log clsLog = LogFactory.getLog((Class)QueryIterBasePattern.class);
    List pattern;
    List constraints = null;
    DatasetGraph data;
    Node[] projectionVars = null;
    Mark mark;
    ClosableIterator graphIter;
    Binding currentBinding;

    public QueryIterBasePattern(Mark mark, DatasetGraph datasetGraph, QueryIterator queryIterator, List list, ExecutionContext executionContext) {
        this(mark, datasetGraph, queryIterator, list, executionContext, null);
    }

    private QueryIterBasePattern(Mark mark, DatasetGraph datasetGraph, QueryIterator queryIterator, List list, ExecutionContext executionContext, List list2) {
        super(clsLog, mark, queryIterator, executionContext);
        this.data = datasetGraph;
        this.pattern = list;
        this.constraints = list2;
    }

    public void nextStage(Mark mark, Binding binding) {
        if (this.logp()) {
            this.logMsg("Start with: " + (binding == null ? "<<null>>" : binding.toString()));
        }
        this.currentBinding = binding;
        QueryHandler queryHandler = this.data.getActiveGraph().queryHandler();
        Query query2 = new Query();
        HashSet hashSet = new HashSet();
        QueryEngineUtils.compilePattern(query2, this.pattern, binding, hashSet);
        this.projectionVars = QueryEngineUtils.projectionVars(hashSet);
        QueryEngineUtils.compileConstraints(query2, this.constraints);
        BindingQueryPlan bindingQueryPlan = queryHandler.prepareBindings(query2, this.projectionVars);
        this.graphIter = bindingQueryPlan.executeBindings();
        if (this.graphIter == null) {
            this.logMsg("Graph Iterator is null");
        }
    }

    protected boolean hasNextBinding_1() {
        boolean bl = this.graphIter.hasNext();
        return bl;
    }

    protected Binding nextB_1() {
        Domain domain = (Domain)this.graphIter.next();
        Binding binding = QueryIterBasePattern.graphResultsToBinding(this.currentBinding, domain, this.projectionVars);
        return binding;
    }

    protected void closeIterator_1() {
        if (!this.isFinished() && this.graphIter != null) {
            this.graphIter.close();
        }
        this.graphIter = null;
    }

    private static Binding graphResultsToBinding(Binding binding, Domain domain, Node[] nodeArray) {
        BindingMap bindingMap = new BindingMap(binding);
        for (int i = 0; i < nodeArray.length; ++i) {
            String string = nodeArray[i].getName();
            Node node = (Node)domain.get(i);
            if (node == null) continue;
            bindingMap.add(string, node);
        }
        return bindingMap;
    }
}

