/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Constraint;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.Mark;
import com.hp.hpl.jena.query.engine1.QueryIterFilter;
import com.hp.hpl.jena.query.expr.ExprException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryIterConstraintFilter
extends QueryIterFilter {
    static Log clsLog = LogFactory.getLog((Class)QueryIterConstraintFilter.class);
    Constraint constraint;

    public QueryIterConstraintFilter(Mark mark, QueryIterator queryIterator, Constraint constraint, ExecutionContext executionContext) {
        super(clsLog, mark, queryIterator, executionContext);
        this.constraint = constraint;
    }

    public boolean accept(Binding binding) {
        boolean bl = false;
        try {
            bl = this.constraint.isSatisfied(binding);
        }
        catch (ExprException exprException) {
            bl = false;
        }
        catch (Exception exception) {
            bl = false;
            this.getLog().warn((Object)("General exeception in " + this.constraint));
        }
        if (!bl) {
            if (this.logp()) {
                this.logMsg("Reject: " + this.constraint + " - " + binding);
            }
            return false;
        }
        if (this.logp()) {
            this.logMsg("Accept: " + this.constraint + " - " + binding);
        }
        return true;
    }
}

