/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.Mark;
import com.hp.hpl.jena.query.engine1.QueryIteratorBase;
import com.hp.hpl.jena.query.util.Utils;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;

public abstract class QueryIterFilter
extends QueryIteratorBase {
    QueryIterator iter;
    Binding nextBinding;

    public abstract boolean accept(Binding var1);

    public QueryIterFilter(Log log, Mark mark, QueryIterator queryIterator, ExecutionContext executionContext) {
        super(log, mark, executionContext);
        this.iter = queryIterator;
        this.nextBinding = null;
    }

    protected boolean hasNextBinding() {
        if (this.isFinished()) {
            return false;
        }
        if (this.nextBinding != null) {
            return true;
        }
        if (this.iter == null) {
            throw new ARQInternalErrorException(Utils.className(this) + ": Null iterator");
        }
        while (this.iter.hasNext()) {
            this.nextBinding = this.iter.nextBinding();
            if (!this.accept(this.nextBinding)) continue;
            return true;
        }
        this.nextBinding = null;
        return false;
    }

    public Binding nextB() {
        if (this.hasNext()) {
            Binding binding = this.nextBinding;
            this.nextBinding = null;
            return binding;
        }
        throw new NoSuchElementException();
    }

    protected void closeIterator() {
        if (this.isFinished()) {
            return;
        }
        this.nextBinding = null;
        this.iter.close();
    }
}

