/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.Mark;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.QueryIterNamedGraphInner;
import com.hp.hpl.jena.query.engine1.QueryIterRepeatApply;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryIterNamedGraph
extends QueryIterRepeatApply {
    private static Log clsLog = LogFactory.getLog((Class)QueryIterNamedGraph.class);
    DatasetGraph data;
    Node sourceNode;
    PlanElement subPattern;
    QueryIterator current = null;
    Iterator graphURIs = null;

    public QueryIterNamedGraph(Mark mark, QueryIterator queryIterator, DatasetGraph datasetGraph, Node node, ExecutionContext executionContext, PlanElement planElement) {
        super(clsLog, mark, queryIterator, executionContext);
        this.data = datasetGraph;
        this.sourceNode = node;
        this.subPattern = planElement;
    }

    protected boolean hasNextBinding_1() {
        return this.current.hasNext();
    }

    protected Binding nextB_1() {
        return this.current.nextBinding();
    }

    protected void closeIterator_1() {
        if (this.isFinished()) {
            return;
        }
        if (this.current != null) {
            this.current.close();
        }
        this.current = null;
    }

    protected void nextStage(Mark mark, Binding binding) {
        this.graphURIs = QueryIterNamedGraph.makeSources(this.data, binding, this.sourceNode);
        this.current = new QueryIterNamedGraphInner(mark, binding, this.sourceNode, this.graphURIs, this.subPattern, this.getContext(), this.data);
    }

    private static Iterator makeSources(DatasetGraph datasetGraph, Binding binding, Node node) {
        Node node2 = QueryIterNamedGraph.resolve(binding, node);
        if (node2 != null && !node2.isURI()) {
            throw new QueryException("GRAPH is not a URI: " + node2);
        }
        if (node2 == null) {
            return datasetGraph.listNames();
        }
        return new SingletonIterator((Object)node2.getURI());
    }

    private static Node resolve(Binding binding, Node node) {
        if (node == null) {
            return node;
        }
        if (!node.isVariable()) {
            return node;
        }
        if (binding == null) {
            return null;
        }
        return binding.get(node.getName());
    }
}

