/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Binding1;
import com.hp.hpl.jena.query.core.DataSourceGraphImpl;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.Mark;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.QueryIterSingleton;
import com.hp.hpl.jena.query.engine1.QueryIteratorBase;
import com.hp.hpl.jena.query.util.Utils;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryIterNamedGraphInner
extends QueryIteratorBase {
    static Log clsLog = LogFactory.getLog((Class)QueryIterNamedGraphInner.class);
    Binding binding;
    Node graphNode;
    Iterator graphURIs;
    PlanElement cElt;
    DatasetGraph data;
    QueryIterator subIter;
    boolean started = false;

    public QueryIterNamedGraphInner(Mark mark, Binding binding, Node node, Iterator iterator, PlanElement planElement, ExecutionContext executionContext, DatasetGraph datasetGraph) {
        super(clsLog, mark, executionContext);
        this.graphURIs = iterator;
        this.cElt = planElement;
        this.data = datasetGraph;
        this.binding = binding;
        this.subIter = null;
        this.graphNode = node;
        this.started = false;
    }

    protected boolean hasNextBinding() {
        do {
            if (this.subIter == null) {
                this.subIter = this.nextIterator();
            }
            if (this.subIter == null) {
                return false;
            }
            if (this.subIter.hasNext()) {
                return true;
            }
            this.subIter.close();
            this.subIter = this.nextIterator();
        } while (this.subIter != null);
        return false;
    }

    protected Binding nextB() {
        if (this.subIter == null) {
            throw new NoSuchElementException(Utils.className(this) + ".nextB");
        }
        return this.subIter.nextBinding();
    }

    protected void closeIterator() {
        if (this.subIter != null) {
            this.subIter.close();
        }
        this.subIter = null;
    }

    private QueryIterator nextIterator() {
        if (!this.graphURIs.hasNext()) {
            return null;
        }
        String string = (String)this.graphURIs.next();
        Graph graph = this.data.getNamedGraph(string);
        if (graph == null) {
            if (this.logp()) {
                this.logMsg("NamedGraph: no such URI: " + string);
            }
            return null;
        }
        DataSourceGraphImpl dataSourceGraphImpl = new DataSourceGraphImpl(this.data);
        dataSourceGraphImpl.setActiveGraph(graph);
        Binding binding = this.binding;
        if (this.graphNode != null && this.graphNode.isVariable()) {
            binding = new Binding1(this.graphNode.getName(), Node.createURI((String)string), this.binding);
        }
        Mark mark = this.getMark();
        QueryIterator queryIterator = this.cElt.exec(mark, new QueryIterSingleton(mark, binding, this.getContext()), this.getContext(), dataSourceGraphImpl);
        return queryIterator;
    }
}

