/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.Mark;
import com.hp.hpl.jena.query.engine1.QueryIteratorBase;
import com.hp.hpl.jena.query.util.Utils;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;

public abstract class QueryIterRepeatApply
extends QueryIteratorBase {
    int count = 0;
    boolean validNextStage = false;
    QueryIterator input;

    public QueryIterRepeatApply(Log log, Mark mark, QueryIterator queryIterator, ExecutionContext executionContext) {
        super(log, mark, executionContext);
        this.input = queryIterator;
        if (this.input == null) {
            this.getLog().fatal((Object)"Repeated application to null input iterator");
            return;
        }
        if (this.logp()) {
            this.logMsg("Start repeat apply: " + this);
        }
        this.validNextStage = false;
    }

    protected abstract void nextStage(Mark var1, Binding var2);

    protected abstract boolean hasNextBinding_1();

    protected abstract Binding nextB_1();

    protected abstract void closeIterator_1();

    protected boolean hasNextBinding() {
        if (this.isFinished()) {
            return false;
        }
        while (true) {
            if (!this.validNextStage) {
                this.makeNextStage();
            }
            if (!this.validNextStage) {
                return false;
            }
            if (this.hasNextBinding_1()) {
                return true;
            }
            this.closeIterator_1();
            this.validNextStage = false;
        }
    }

    protected Binding nextB() {
        if (!this.hasNextBinding()) {
            throw new NoSuchElementException(Utils.className(this) + ".next()/finished");
        }
        return this.nextB_1();
    }

    private void makeNextStage() {
        Mark mark = new Mark(this.getMark());
        ++this.count;
        mark.setCount(this.count);
        if (this.input == null) {
            this.validNextStage = false;
            return;
        }
        if (!this.input.hasNext()) {
            this.input.close();
            this.input = null;
            this.validNextStage = false;
            return;
        }
        Binding binding = (Binding)this.input.next();
        if (this.logp()) {
            this.logMsg("New stage: Binding: " + binding);
        }
        this.nextStage(mark, binding);
        this.validNextStage = true;
    }

    protected void closeIterator() {
        if (!this.isFinished()) {
            this.closeIterator_1();
            if (this.input != null) {
                this.input.close();
            }
            this.input = null;
        }
    }
}

