/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.Mark;
import com.hp.hpl.jena.query.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class QueryIteratorBase
implements QueryIterator {
    public static int iteratorCounter = 0;
    public int iteratorNumber = iteratorCounter++;
    private Log log = null;
    private boolean finished = false;
    private Mark mark;
    private ExecutionContext tracker;
    private boolean caching = false;
    private boolean cacheInit = false;
    private List cache = null;
    private Iterator cacheIterator = null;

    public QueryIteratorBase(Log log, Mark mark, ExecutionContext executionContext) {
        this.mark = mark;
        this.log = log;
        if (log == null) {
            log = LogFactory.getLog((Class)QueryIterator.class);
        }
        this.tracker = executionContext;
        this.register();
    }

    public QueryIteratorBase(Log log, ExecutionContext executionContext) {
        this(log, null, executionContext);
    }

    protected abstract boolean hasNextBinding();

    protected abstract Binding nextB();

    protected abstract void closeIterator();

    public final boolean hasNext() {
        if (this.caching && !this.cacheInit) {
            this.cacheInit();
        }
        if (this.finished) {
            if (this.logp()) {
                this.logMsg("hasNext: already closed");
            }
            return false;
        }
        boolean bl = this._hasNextBinding();
        if (!bl) {
            if (this.logp()) {
                this.logMsg("hasNext: autoClose");
            }
            this.close();
        }
        if (this.logp()) {
            this.logMsg("hasNext: => " + (bl ? "true" : "false"));
        }
        return bl;
    }

    public final Object next() {
        if (this.finished) {
            if (this.logp()) {
                this.logMsg("next: already closed");
            }
            throw new NoSuchElementException();
        }
        if (!this._hasNextBinding()) {
            if (this.logp()) {
                this.logMsg("next: No more");
            }
            throw new NoSuchElementException();
        }
        Binding binding = this._nextB();
        if (this.logp()) {
            this.logMsg("next: " + binding);
        }
        return binding;
    }

    public final Binding nextBinding() {
        return (Binding)this.next();
    }

    public final void remove() {
        if (this.mark != null) {
            this.log.warn((Object)"Call to QueryIterator.remove()");
        } else {
            this.log.warn((Object)this.mark.msg("Call to QueryIterator.remove()"));
        }
        throw new UnsupportedOperationException();
    }

    public final void close() {
        if (this.finished) {
            return;
        }
        this.closeIterator();
        this.deregister();
        this.finished = true;
        if (this.caching) {
            this.cache = null;
            this.cacheIterator = null;
        }
    }

    private boolean _hasNextBinding() {
        if (this.caching) {
            return this.cacheHasNext();
        }
        return this.hasNextBinding();
    }

    private Binding _nextB() {
        if (this.caching) {
            return this.cacheNext();
        }
        return this.nextB();
    }

    private Binding cacheNext() {
        return (Binding)this.cacheIterator.next();
    }

    private boolean cacheHasNext() {
        return this.cacheIterator.hasNext();
    }

    private void cacheInit() {
        this.cache = new ArrayList();
        while (this.hasNextBinding()) {
            Binding binding = this.nextB();
            this.cache.add(binding);
        }
        this.cacheInit = true;
        this.cacheIterator = this.cache.listIterator();
    }

    public ExecutionContext getContext() {
        return this.tracker;
    }

    public Mark getMark() {
        return this.mark;
    }

    public String toString() {
        return Utils.className(this);
    }

    private void register() {
        if (this.tracker != null) {
            this.tracker.openIterator(this);
        }
    }

    private void deregister() {
        if (this.tracker != null) {
            this.tracker.closedIterator(this);
        }
    }

    protected Log getLog() {
        return this.log;
    }

    protected boolean logp() {
        return this.log.isDebugEnabled();
    }

    protected void logMsg(String string) {
        if (this.mark != null) {
            this.log.debug((Object)this.mark.msg(string));
        } else {
            this.log.debug((Object)string);
        }
    }

    protected boolean isFinished() {
        return this.finished;
    }
}

