/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.analyse;

import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanFormatter;
import com.hp.hpl.jena.query.engine1.analyse.PlanVarsMentioned;
import com.hp.hpl.jena.query.engine1.analyse.VarUsageVisitor;
import com.hp.hpl.jena.query.engine1.compiler.PlanBasePattern;
import com.hp.hpl.jena.query.engine1.compiler.PlanElementBase;
import com.hp.hpl.jena.query.engine1.compiler.PlanFilter;
import com.hp.hpl.jena.query.engine1.compiler.PlanGroup;
import com.hp.hpl.jena.query.engine1.compiler.PlanTriplePattern;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AnalyseFilters {
    static Log log = LogFactory.getLog((Class)AnalyseFilters.class);
    PlanGroup planGroup;
    List basePlanElements = new ArrayList();
    List filterPlanElements = new ArrayList();
    List unknownFilterPlanElements = new ArrayList();
    List otherPlanElements = new ArrayList();
    List ordered = new ArrayList();

    public AnalyseFilters(PlanGroup planGroup) {
        this.planGroup = planGroup;
        this.buildStructures();
        this.analyse();
    }

    private void buildStructures() {
        Iterator iterator = this.planGroup.getPlanElements().iterator();
        while (iterator.hasNext()) {
            PlanElementBase planElementBase;
            PlanElement planElement = (PlanElement)iterator.next();
            if (planElement instanceof PlanTriplePattern) {
                planElementBase = (PlanTriplePattern)planElement;
                this.basePlanElements.add(planElementBase);
                continue;
            }
            if (planElement instanceof PlanBasePattern) {
                planElementBase = (PlanBasePattern)planElement;
                this.basePlanElements.add(planElementBase);
                continue;
            }
            if (planElement instanceof PlanFilter) {
                planElementBase = (PlanFilter)planElement;
                this.filterPlanElements.add(planElementBase);
                continue;
            }
            this.otherPlanElements.add(planElement);
        }
    }

    private void analyse() {
        HashSet hashSet = new HashSet();
        this.insertFilters(hashSet);
        Iterator iterator = this.basePlanElements.iterator();
        while (iterator.hasNext()) {
            PlanBasePattern planBasePattern = (PlanBasePattern)iterator.next();
            VarUsageVisitor varUsageVisitor = new VarUsageVisitor();
            planBasePattern.visit(varUsageVisitor);
            hashSet.addAll(varUsageVisitor.getFixedUsageVars());
            this.ordered.add(planBasePattern);
            this.insertFilters(hashSet);
        }
        this.unknownFilterPlanElements.addAll(this.filterPlanElements);
    }

    private void insertFilters(Set set) {
        Iterator iterator = this.filterPlanElements.iterator();
        while (iterator.hasNext()) {
            PlanFilter planFilter = (PlanFilter)iterator.next();
            Set set2 = PlanVarsMentioned.varMentioned(planFilter);
            if (!set.containsAll(set2)) continue;
            this.ordered.add(planFilter);
            iterator.remove();
        }
    }

    public void report(PrefixMapping prefixMapping) {
        List list = this.reorder();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PlanElement planElement = (PlanElement)iterator.next();
            PlanFormatter.out((OutputStream)System.out, prefixMapping, planElement);
        }
    }

    public List reorder() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.ordered);
        arrayList.addAll(this.otherPlanElements);
        arrayList.addAll(this.unknownFilterPlanElements);
        return arrayList;
    }
}

