/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.analyse;

import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanFormatter;
import com.hp.hpl.jena.query.engine1.analyse.PlanEltTypeVisitor;
import com.hp.hpl.jena.query.engine1.analyse.VarUsageVisitor;
import com.hp.hpl.jena.query.engine1.compiler.PlanGroup;
import com.hp.hpl.jena.query.engine1.compiler.PlanOuterJoin;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AnalyseOrderSets {
    static Log log = LogFactory.getLog((Class)AnalyseOrderSets.class);
    PlanEltTypeVisitor eltTypes;
    Map elsFixedVars = new HashMap();
    Map elsOptVars = new HashMap();
    Map fixedVars = new HashMap();
    Map varOpts = new HashMap();
    Set equivSets = new HashSet();
    PlanGroup planGroup;

    public AnalyseOrderSets(PlanGroup planGroup) {
        this.planGroup = planGroup;
        this.buildInitialStructures();
        this.analyse();
    }

    public Set getEquivalenceSets() {
        return this.equivSets;
    }

    private void buildInitialStructures() {
        Object object;
        Iterator iterator;
        if (this.planGroup.getPlanElements().size() == 1) {
            return;
        }
        this.eltTypes = new PlanEltTypeVisitor();
        Object object2 = this.planGroup.getPlanElements().listIterator();
        while (object2.hasNext()) {
            iterator = (PlanElement)object2.next();
            iterator.visit(this.eltTypes);
        }
        object2 = new HashSet();
        iterator = this.planGroup.getPlanElements().listIterator();
        while (iterator.hasNext()) {
            String string;
            object = (PlanElement)iterator.next();
            VarUsageVisitor varUsageVisitor = new VarUsageVisitor();
            object.visit(varUsageVisitor);
            this.elsFixedVars.put(object, varUsageVisitor.getFixedUsageVars());
            this.elsOptVars.put(object, varUsageVisitor.getOptionalUsageVars());
            object2.addAll(varUsageVisitor.getFixedUsageVars());
            Iterator iterator2 = varUsageVisitor.getFixedUsageVars().iterator();
            while (iterator2.hasNext()) {
                string = (String)iterator2.next();
                this.insert(this.fixedVars, string, object);
            }
            iterator2 = varUsageVisitor.getOptionalUsageVars().iterator();
            while (iterator2.hasNext()) {
                string = (String)iterator2.next();
                this.insert(this.varOpts, string, object);
            }
        }
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            this.varOpts.remove(object);
        }
    }

    private void analyse() {
        if (this.planGroup.getPlanElements().size() == 1) {
            return;
        }
        HashSet hashSet = new HashSet();
        Iterator iterator = this.varOpts.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (hashSet.contains(string)) continue;
            HashSet hashSet2 = new HashSet();
            AnalyseOrderSets.combine(hashSet2, string, hashSet, this.varOpts, this.elsOptVars);
            if (hashSet2.size() > 0) {
                this.equivSets.add(hashSet2);
                continue;
            }
            log.warn((Object)("Found a zero sized reachabliltiy set for var ?" + string));
        }
    }

    private static void combine(Set set, String string, Set set2, Map map, Map map2) {
        if (set2.contains(string)) {
            return;
        }
        set2.add(string);
        Set set3 = (Set)map.get(string);
        if (set3 == null) {
            return;
        }
        Iterator iterator = set3.iterator();
        while (iterator.hasNext()) {
            PlanElement planElement = (PlanElement)iterator.next();
            if (set.contains(planElement)) continue;
            set.add(planElement);
            Iterator iterator2 = ((Set)map2.get(planElement)).iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                AnalyseOrderSets.combine(set, string2, set2, map, map2);
            }
        }
    }

    public List reorder() {
        PlanElement planElement;
        Set set;
        if (this.planGroup.getPlanElements().size() == 1) {
            return this.planGroup.getPlanElements();
        }
        ArrayList<PlanElement> arrayList = new ArrayList<PlanElement>();
        arrayList.addAll(this.eltTypes.fixedPlanElt);
        arrayList.addAll(this.eltTypes.groupPlanElt);
        arrayList.addAll(this.eltTypes.filterPlanElt);
        arrayList.addAll(this.eltTypes.otherPlanElt);
        Iterator iterator = this.equivSets.iterator();
        while (iterator.hasNext()) {
            set = (Set)iterator.next();
            if (set.size() == 1 && !arrayList.contains(planElement = (PlanElement)set.iterator().next())) {
                arrayList.add(planElement);
            }
            if (set.size() != 0) continue;
            log.warn((Object)"Optional reachability set of size zero");
        }
        iterator = this.equivSets.iterator();
        while (iterator.hasNext()) {
            set = (Set)iterator.next();
            if (set.size() <= 1) continue;
            planElement = PlanOuterJoin.make(this.planGroup.getPlan(), set);
            arrayList.add(planElement);
        }
        return arrayList;
    }

    public void report(PrefixMapping prefixMapping) {
        Object object;
        Object object2;
        if (this.planGroup.getPlanElements().size() == 1) {
            return;
        }
        Object object3 = this.equivSets.iterator();
        while (object3.hasNext()) {
            object2 = (Set)object3.next();
            if (object2.size() == 1) continue;
            System.out.println("Equivalence: ");
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (PlanElement)iterator.next();
                PlanFormatter.out((OutputStream)System.out, prefixMapping, (PlanElement)object);
            }
        }
        System.out.println();
        object3 = this.planGroup.getPlanElements().iterator();
        while (object3.hasNext()) {
            object2 = (PlanElement)object3.next();
            int n = 0;
            object = this.equivSets.iterator();
            while (object.hasNext()) {
                Set set = (Set)object.next();
                if (!set.contains(object2)) continue;
                ++n;
            }
            if (n <= true) continue;
            System.out.println("Count = " + n);
            PlanFormatter.out((OutputStream)System.out, prefixMapping, object2);
        }
        System.out.println();
        object3 = this.reorder();
        System.out.println();
        System.out.println("Group plan:");
        object2 = object3.iterator();
        while (object2.hasNext()) {
            PlanElement planElement = (PlanElement)object2.next();
            PlanFormatter.out((OutputStream)System.out, prefixMapping, planElement);
        }
    }

    private void insert(Map map, Object object, Object object2) {
        if (map.get(object) == null) {
            map.put(object, new HashSet());
        }
        ((Set)map.get(object)).add(object2);
    }
}

