/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.analyse;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitorBase;
import com.hp.hpl.jena.query.engine1.PlanWalker;
import com.hp.hpl.jena.query.engine1.compiler.PlanBasePattern;
import com.hp.hpl.jena.query.engine1.compiler.PlanDistinct;
import com.hp.hpl.jena.query.engine1.compiler.PlanFilter;
import com.hp.hpl.jena.query.engine1.compiler.PlanGroup;
import com.hp.hpl.jena.query.engine1.compiler.PlanNamedGraph;
import com.hp.hpl.jena.query.engine1.compiler.PlanTriplePattern;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;

public class PlanVarsMentioned
extends PlanVisitorBase {
    Set acc;

    public static Set varMentioned(PlanElement planElement) {
        HashSet hashSet = new HashSet();
        PlanVarsMentioned planVarsMentioned = new PlanVarsMentioned(hashSet);
        PlanWalker planWalker = new PlanWalker(planVarsMentioned);
        planWalker.walk(planElement);
        return hashSet;
    }

    public PlanVarsMentioned(Set set) {
        this.acc = set;
    }

    public void visit(PlanBasePattern planBasePattern) {
        ListIterator listIterator = planBasePattern.triples();
        while (listIterator.hasNext()) {
            Triple triple = (Triple)listIterator.next();
            PlanVarsMentioned.addVarsFromTriple(this.acc, triple);
        }
    }

    public void visit(PlanTriplePattern planTriplePattern) {
        Triple triple = planTriplePattern.getTriple();
        PlanVarsMentioned.addVarsFromTriple(this.acc, triple);
    }

    public void visit(PlanGroup planGroup) {
    }

    public void visit(PlanFilter planFilter) {
        planFilter.getConstraint().varsMentioned(this.acc);
    }

    public void visit(PlanNamedGraph planNamedGraph) {
        PlanVarsMentioned.addVar(this.acc, planNamedGraph.getElement().getGraphNameNode());
    }

    public void visit(PlanDistinct planDistinct) {
    }

    private static void addVarsFromTriple(Set set, Triple triple) {
        PlanVarsMentioned.addVar(set, triple.getSubject());
        PlanVarsMentioned.addVar(set, triple.getPredicate());
        PlanVarsMentioned.addVar(set, triple.getObject());
    }

    private static void addVar(Set set, Node node) {
        if (node == null) {
            return;
        }
        if (node.isVariable()) {
            set.add(node.getName());
        }
    }
}

