/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.analyse;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.compiler.PlanBasePattern;
import com.hp.hpl.jena.query.engine1.compiler.PlanBlock;
import com.hp.hpl.jena.query.engine1.compiler.PlanDistinct;
import com.hp.hpl.jena.query.engine1.compiler.PlanExtension;
import com.hp.hpl.jena.query.engine1.compiler.PlanFilter;
import com.hp.hpl.jena.query.engine1.compiler.PlanGroup;
import com.hp.hpl.jena.query.engine1.compiler.PlanLimitOffset;
import com.hp.hpl.jena.query.engine1.compiler.PlanNamedGraph;
import com.hp.hpl.jena.query.engine1.compiler.PlanOptional;
import com.hp.hpl.jena.query.engine1.compiler.PlanOrderBy;
import com.hp.hpl.jena.query.engine1.compiler.PlanOuterJoin;
import com.hp.hpl.jena.query.engine1.compiler.PlanProject;
import com.hp.hpl.jena.query.engine1.compiler.PlanTriplePattern;
import com.hp.hpl.jena.query.engine1.compiler.PlanUnion;
import com.hp.hpl.jena.query.engine1.compiler.PlanUnsaid;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.logging.LogFactory;

public class VarUsageVisitor
implements PlanVisitor {
    private Set fixedUsageVars;
    private Set optionalUsageVars;
    private Set constraintUsageVars;

    public VarUsageVisitor() {
        this(new HashSet(), new HashSet(), new HashSet());
    }

    public VarUsageVisitor(Set set, Set set2, Set set3) {
        this.fixedUsageVars = set;
        this.optionalUsageVars = set2;
        this.constraintUsageVars = set3;
    }

    public void visit(PlanBasePattern planBasePattern) {
        ListIterator listIterator = planBasePattern.triples();
        while (listIterator.hasNext()) {
            Triple triple = (Triple)listIterator.next();
            VarUsageVisitor.addVarsFromTriple(this.fixedUsageVars, triple);
            this.delVarsFromTriple(this.optionalUsageVars, triple);
        }
    }

    public void visit(PlanTriplePattern planTriplePattern) {
        Triple triple = planTriplePattern.getTriple();
        VarUsageVisitor.addVarsFromTriple(this.fixedUsageVars, triple);
        this.delVarsFromTriple(this.optionalUsageVars, triple);
    }

    public void visit(PlanGroup planGroup) {
        Iterator iterator = planGroup.getPlanElements().iterator();
        while (iterator.hasNext()) {
            PlanElement planElement = (PlanElement)iterator.next();
            planElement.visit(this);
        }
    }

    public void visit(PlanUnion planUnion) {
        Iterator iterator = planUnion.getPlanElements().iterator();
        while (iterator.hasNext()) {
            PlanElement planElement = (PlanElement)iterator.next();
            planElement.visit(this);
        }
    }

    public void visit(PlanOptional planOptional) {
        VarUsageVisitor varUsageVisitor = new VarUsageVisitor();
        planOptional.getSub().visit(varUsageVisitor);
        varUsageVisitor.getOptionalUsageVars().addAll(varUsageVisitor.getFixedUsageVars());
        varUsageVisitor.getOptionalUsageVars().removeAll(this.getFixedUsageVars());
        this.optionalUsageVars.addAll(varUsageVisitor.getOptionalUsageVars());
    }

    public void visit(PlanUnsaid planUnsaid) {
        VarUsageVisitor varUsageVisitor = new VarUsageVisitor(this.constraintUsageVars, this.constraintUsageVars, this.constraintUsageVars);
        planUnsaid.getSub().visit(varUsageVisitor);
    }

    public void visit(PlanFilter planFilter) {
        planFilter.getConstraint().varsMentioned(this.constraintUsageVars);
    }

    public void visit(PlanNamedGraph planNamedGraph) {
        Node node = planNamedGraph.getElement().getGraphNameNode();
        VarUsageVisitor.addVar(this.fixedUsageVars, node);
        planNamedGraph.getSub().visit(this);
    }

    public void visit(PlanOuterJoin planOuterJoin) {
        LogFactory.getLog((Class)VarUsageVisitor.class).warn((Object)"PlanOuterJoin - VarUsage - Should not be called");
        Iterator iterator = planOuterJoin.getPlanElements().iterator();
        while (iterator.hasNext()) {
            PlanElement planElement = (PlanElement)iterator.next();
            planElement.visit(this);
        }
    }

    public void visit(PlanExtension planExtension) {
    }

    public void visit(PlanBlock planBlock) {
    }

    public void visit(PlanDistinct planDistinct) {
    }

    public void visit(PlanProject planProject) {
    }

    public void visit(PlanOrderBy planOrderBy) {
    }

    public void visit(PlanLimitOffset planLimitOffset) {
    }

    private static void addVarsFromTriple(Set set, Triple triple) {
        VarUsageVisitor.addVar(set, triple.getSubject());
        VarUsageVisitor.addVar(set, triple.getPredicate());
        VarUsageVisitor.addVar(set, triple.getObject());
    }

    private static void addVar(Set set, Node node) {
        if (node == null) {
            return;
        }
        if (node.isVariable()) {
            set.add(node.getName());
        }
    }

    private void delVarsFromTriple(Set set, Triple triple) {
        this.delVar(set, triple.getSubject());
        this.delVar(set, triple.getPredicate());
        this.delVar(set, triple.getObject());
    }

    private void delVar(Set set, Node node) {
        if (node == null) {
            return;
        }
        if (node.isVariable()) {
            set.remove(node.getName());
        }
    }

    public Set getFixedUsageVars() {
        return this.fixedUsageVars;
    }

    public Set getConstraintUsageVars() {
        return this.constraintUsageVars;
    }

    public Set getOptionalUsageVars() {
        return this.optionalUsageVars;
    }
}

