/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.compiler;

import com.hp.hpl.jena.query.core.Binding0;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.core.ElementExtension;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.CompileException;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.Mark;
import com.hp.hpl.jena.query.engine1.Plan;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.QueryIterSingleton;
import com.hp.hpl.jena.query.engine1.compiler.PlanElementBase;
import com.hp.hpl.jena.query.extension.ExtensionPoint;
import com.hp.hpl.jena.query.extension.ExtensionRegistry;

public class PlanExtension
extends PlanElementBase {
    ElementExtension element;

    public static PlanElement make(Plan plan, ElementExtension elementExtension) {
        return new PlanExtension(plan, elementExtension);
    }

    private PlanExtension(Plan plan, ElementExtension elementExtension) {
        super(plan);
        this.element = elementExtension;
    }

    public QueryIterator exec(Mark mark, QueryIterator queryIterator, ExecutionContext executionContext, DatasetGraph datasetGraph) {
        String string = this.element.getURI();
        ExtensionPoint extensionPoint = ExtensionRegistry.global().get(string);
        if (extensionPoint == null) {
            throw new CompileException("No extension for '" + string + "'");
        }
        if (queryIterator == null) {
            queryIterator = new QueryIterSingleton(mark, new Binding0(), executionContext);
        }
        return extensionPoint.compile(mark, queryIterator, this.element, executionContext, datasetGraph);
    }

    public void visit(PlanVisitor planVisitor) {
        planVisitor.visit(this);
    }
}

