/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.compiler;

import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.Mark;
import com.hp.hpl.jena.query.engine1.Plan;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanFormatter;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.analyse.AnalyseFilters;
import com.hp.hpl.jena.query.engine1.analyse.AnalyseOrderSets;
import com.hp.hpl.jena.query.engine1.analyse.VarUsageVisitor;
import com.hp.hpl.jena.query.engine1.compiler.PlanBasePattern;
import com.hp.hpl.jena.query.engine1.compiler.PlanElementBase;
import com.hp.hpl.jena.query.engine1.compiler.PlanTriplePattern;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlanGroup
extends PlanElementBase {
    static Log log = LogFactory.getLog((Class)PlanGroup.class);
    public static boolean enableOrderWarnings = true;
    List planElements = new ArrayList();
    private boolean canReorder = true;

    public static PlanElement make(Plan plan, List list) {
        if (list.size() == 1) {
            return (PlanElement)list.get(0);
        }
        return new PlanGroup(plan, list, true);
    }

    public static PlanGroup make(Plan plan, List list, boolean bl) {
        return new PlanGroup(plan, list, bl);
    }

    public boolean canReorder() {
        return this.canReorder;
    }

    private PlanGroup(Plan plan, List list, boolean bl) {
        super(plan);
        this.planElements = list;
        this.canReorder = bl;
        this.planElements = this.compressBasicPatterns(this.planElements);
        if (plan.orderPlanning()) {
            this.planGroup();
        }
    }

    private void planGroup() {
        if (!this.canReorder) {
            return;
        }
        AnalyseOrderSets analyseOrderSets = new AnalyseOrderSets(this);
        this.planElements = analyseOrderSets.reorder();
        AnalyseFilters analyseFilters = new AnalyseFilters(this);
        this.planElements = analyseFilters.reorder();
    }

    public List getPlanElements() {
        return this.planElements;
    }

    public QueryIterator exec(Mark mark, QueryIterator queryIterator, ExecutionContext executionContext, DatasetGraph datasetGraph) {
        if (this.planElements.size() == 0) {
            return queryIterator;
        }
        if (this.planElements.size() == 1) {
            PlanElement planElement = (PlanElement)this.planElements.get(0);
            Mark mark2 = new Mark(mark);
            log.debug((Object)mark2.msg("New group stage (1 step)"));
            return planElement.exec(mark2, queryIterator, executionContext, datasetGraph);
        }
        int n = 0;
        ListIterator listIterator = this.planElements.listIterator();
        QueryIterator queryIterator2 = queryIterator;
        while (listIterator.hasNext()) {
            QueryIterator queryIterator3;
            PlanElement planElement = (PlanElement)listIterator.next();
            Mark mark3 = new Mark(mark);
            mark3.setOffset(++n);
            log.debug((Object)mark3.msg("New group stage"));
            queryIterator2 = queryIterator3 = planElement.exec(mark3, queryIterator2, executionContext, datasetGraph);
        }
        return queryIterator2;
    }

    public void visit(PlanVisitor planVisitor) {
        planVisitor.visit(this);
    }

    private List compressBasicPatterns(List list) {
        ArrayList<PlanElement> arrayList = new ArrayList<PlanElement>();
        for (int i = 0; i < list.size(); ++i) {
            int n;
            PlanElement planElement = (PlanElement)list.get(i);
            if (!(planElement instanceof PlanTriplePattern)) {
                arrayList.add(planElement);
                continue;
            }
            PlanTriplePattern planTriplePattern = (PlanTriplePattern)planElement;
            PlanBasePattern planBasePattern = new PlanBasePattern(this.getPlan());
            planBasePattern.getPattern().add(planTriplePattern.getTriple());
            arrayList.add(planBasePattern);
            for (n = i + 1; n < list.size(); ++n) {
                PlanElement planElement2 = (PlanElement)list.get(n);
                if (!(planElement2 instanceof PlanTriplePattern)) {
                    arrayList.add(planElement2);
                    break;
                }
                PlanTriplePattern planTriplePattern2 = (PlanTriplePattern)planElement2;
                planBasePattern.getPattern().add(planTriplePattern2.getTriple());
            }
            i = n;
        }
        return arrayList;
    }

    private void warnOrderDependence(AnalyseOrderSets analyseOrderSets) {
        Iterator iterator = analyseOrderSets.getEquivalenceSets().iterator();
        while (iterator.hasNext()) {
            Set set = (Set)iterator.next();
            if (!enableOrderWarnings || set.size() == 1) continue;
            log.warn((Object)"Potential order dependence");
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                PlanElement planElement = (PlanElement)iterator2.next();
                PlanFormatter.out((OutputStream)System.out, planElement);
            }
        }
    }

    public void varsReport() {
        String string;
        VarUsageVisitor varUsageVisitor = new VarUsageVisitor();
        this.visit(varUsageVisitor);
        System.out.println();
        System.out.print("Fixed:  ");
        Iterator iterator = varUsageVisitor.getFixedUsageVars().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            System.out.print(" " + string);
        }
        System.out.println();
        System.out.print("Varying:");
        iterator = varUsageVisitor.getOptionalUsageVars().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            System.out.print(" " + string);
        }
        System.out.println();
        System.out.print("Constrained:");
        iterator = varUsageVisitor.getConstraintUsageVars().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            System.out.print(" " + string);
        }
        System.out.println();
    }
}

