/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.compiler;

import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.Mark;
import com.hp.hpl.jena.query.engine1.Plan;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.analyse.PlanVarsMentioned;
import com.hp.hpl.jena.query.engine1.compiler.PlanDistinct;
import com.hp.hpl.jena.query.engine1.compiler.PlanElementBase;
import com.hp.hpl.jena.query.engine1.compiler.PlanGroup;
import com.hp.hpl.jena.query.engine1.compiler.PlanUnion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlanOuterJoin
extends PlanElementBase {
    static Log log = LogFactory.getLog((Class)PlanOuterJoin.class);
    Set planElements;
    PlanElement planElement;

    public static PlanElement make(Plan plan, Set set) {
        PlanElement planElement = PlanOuterJoin.permute(plan, set);
        Set set2 = PlanVarsMentioned.varMentioned(planElement);
        planElement = PlanDistinct.make(plan, planElement, set2);
        return planElement;
    }

    private PlanOuterJoin(Plan plan, Set set) {
        super(plan);
        this.planElements = set;
        this.planElement = PlanOuterJoin.permute(this.getPlan(), set);
    }

    public Set getPlanElements() {
        return this.planElements;
    }

    public QueryIterator exec(Mark mark, QueryIterator queryIterator, ExecutionContext executionContext, DatasetGraph datasetGraph) {
        return this.planElement.exec(mark, queryIterator, executionContext, datasetGraph);
    }

    private static PlanElement permute(Plan plan, Set set) {
        if (set.size() != 2) {
            log.fatal((Object)("Can only permute 2 elements - not " + set.size()));
            return null;
        }
        Iterator iterator = set.iterator();
        PlanElement planElement = (PlanElement)iterator.next();
        PlanElement planElement2 = (PlanElement)iterator.next();
        ArrayList<PlanElement> arrayList = new ArrayList<PlanElement>();
        arrayList.add(planElement);
        arrayList.add(planElement2);
        PlanGroup planGroup = PlanGroup.make(plan, arrayList, false);
        ArrayList<PlanElement> arrayList2 = new ArrayList<PlanElement>();
        arrayList2.add(planElement2);
        arrayList2.add(planElement);
        PlanGroup planGroup2 = PlanGroup.make(plan, arrayList2, false);
        ArrayList<PlanGroup> arrayList3 = new ArrayList<PlanGroup>();
        arrayList3.add(planGroup);
        arrayList3.add(planGroup2);
        PlanElement planElement3 = PlanUnion.make(plan, arrayList3);
        return planElement3;
    }

    public void visit(PlanVisitor planVisitor) {
        planVisitor.visit(this);
    }
}

