/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.compiler;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.Mark;
import com.hp.hpl.jena.query.engine1.Plan;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.QueryIterNullIterator;
import com.hp.hpl.jena.query.engine1.compiler.PlanBasePattern;
import com.hp.hpl.jena.query.engine1.compiler.PlanElementBase;
import org.apache.commons.logging.LogFactory;

public class PlanTriplePattern
extends PlanElementBase {
    ElementTriplePattern elementTriple;

    public static PlanElement make(Plan plan, ElementTriplePattern elementTriplePattern) {
        return new PlanTriplePattern(plan, elementTriplePattern);
    }

    private PlanTriplePattern(Plan plan, ElementTriplePattern elementTriplePattern) {
        super(plan);
        this.elementTriple = elementTriplePattern;
    }

    public Triple getTriple() {
        return this.elementTriple.getTriple();
    }

    public QueryIterator exec(Mark mark, QueryIterator queryIterator, ExecutionContext executionContext, DatasetGraph datasetGraph) {
        if (this.elementTriple == null) {
            LogFactory.getLog((Class)ElementTriplePattern.class).warn((Object)"Triple is null");
            return new QueryIterNullIterator(executionContext);
        }
        PlanBasePattern planBasePattern = new PlanBasePattern(this.getPlan());
        planBasePattern.addTriples(this.elementTriple.getTriple());
        return planBasePattern.exec(mark, queryIterator, executionContext, datasetGraph);
    }

    public void visit(PlanVisitor planVisitor) {
        planVisitor.visit(this);
    }
}

